/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_SOURCE_MANAGER_H__
#define __BKL_SOURCE_MANAGER_H__

#include <glib-object.h>

#include "bkl-source.h"

G_BEGIN_DECLS

#define BKL_TYPE_SOURCE_MANAGER                                         \
   (bkl_source_manager_get_type())
#define BKL_SOURCE_MANAGER(obj)                                         \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_SOURCE_MANAGER,                \
                                BklSourceManager))
#define BKL_SOURCE_MANAGER_CLASS(klass)                                 \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_SOURCE_MANAGER,                   \
                             BklSourceManagerClass))
#define IS_BKL_SOURCE_MANAGER(obj)                                      \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_SOURCE_MANAGER))
#define IS_BKL_SOURCE_MANAGER_CLASS(klass)                              \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_SOURCE_MANAGER))
#define BKL_SOURCE_MANAGER_GET_CLASS(obj)                               \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_SOURCE_MANAGER,                 \
                               BklSourceManagerClass))

typedef struct _BklSourceManagerPrivate BklSourceManagerPrivate;
typedef struct _BklSourceManager      BklSourceManager;
typedef struct _BklSourceManagerClass BklSourceManagerClass;

struct _BklSourceManager
{
    GObject parent;

    BklSourceManagerPrivate *priv;
};

struct _BklSourceManagerClass
{
    GObjectClass parent_class;
};

GType bkl_source_manager_get_type (void) G_GNUC_CONST;
void bkl_source_manager_add_source (BklSourceManager *manager,
                                    BklSource        *source);
void bkl_source_manager_remove_source (BklSourceManager *manager,
                                       BklSource        *source);

G_END_DECLS

#endif /* __BKL_SOURCE_MANAGER_H__ */
