/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_ODTUTILS_H
#define INCLUDED_ODTUTILS_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>


void odt_paragraph_style (vector<ustring>& lines, const ustring& name,
                          const ustring& fontname,
                          double fontsize, int lineheight,
                          const ustring& italic, const ustring& bold, 
                          const ustring& underline, const ustring& smallcaps,
                          ustring justification,
                          double spacebefore, double spaceafter,
                          double leftmargin, double rightmargin,
                          double firstlineindent, bool spancolumns,
                          bool startpage);
void odt_span_style (vector<ustring>& lines, const ustring& name,
                     const ustring& fontname,
                     double fontpercentage, const ustring& italic, const ustring& bold, 
                     const ustring& underline, const ustring& smallcaps, bool superscript,
                     unsigned int color);


class OdtTextParagraph
{
public:
  OdtTextParagraph (vector<ustring> * lines, const ustring& stylename);
  ~OdtTextParagraph ();
  void newline ();
  void plaintext (const ustring& line);
  void spannedtext (const ustring& line, const ustring& stylename);
private:
  ustring myline;
  vector<ustring> * mylines;
  size_t linelength;
  bool mynewline;
};


ustring odt_styles_xml_filename (const ustring& directory);
ustring odt_content_xml_filename (const ustring& directory);
void odt_create_page_master (const ustring& directory);
void odt_set_font (const ustring& directory, const ustring& fontname);
void odt_insert_content (const ustring& directory, const vector <ustring>& text, const vector <ustring>& styles);
void odt_insert_styles (const ustring& directory, const vector <ustring>& styles);
ustring odt_span_fontpercentage (double fontpercentage);
ustring odt_span_italic (const ustring& italic);
ustring odt_span_bold (const ustring& bold);
ustring odt_span_underline (const ustring& underline);
ustring odt_span_smallcaps (const ustring& smallcaps);
ustring odt_span_superscript (bool superscript);
ustring odt_span_color (unsigned int color);


#endif
