/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "htmlbrowser.h"
#include "help.h"


void help_button (GtkWidget * box, Shortcuts * shortcuts, gchar * topic)
{
  gchar * mytopic = topic;
  if (!mytopic) mytopic = "none";
  GtkWidget *helpbutton = gtk_button_new_from_stock ("gtk-help");
  if (shortcuts) shortcuts->stockbutton (helpbutton);
  gtk_widget_show (helpbutton);
  gtk_box_pack_start (GTK_BOX (box), helpbutton, FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (helpbutton, GTK_CAN_DEFAULT);
  g_signal_connect ((gpointer) helpbutton, "clicked", G_CALLBACK (help_open), gpointer (mytopic));
}


void help_open (GtkButton * button, gpointer user_data)
{
  gchar * file = (gchar *) user_data;
  ustring url = "localhost:51516/olh_";
  url.append (file);
  url.append (".html");
  htmlbrowser (url, true); 
}
