/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "color.h"
#include "utilities.h"


void color_decimal_to_gdk (unsigned int colour, GdkColor * color)
{
  guint16 red, green, blue;
  blue = colour % 256;
  colour = colour / 256;
  green = colour % 256;
  colour = colour / 256;
  red = colour;
  color->red = 256 * red;
  color->green = 256 * green;
  color->blue = 256 * blue;
}


unsigned int color_gdk_to_decimal (GdkColor * color)
{
  unsigned int result;
  result = (65536 * (color->red / 256)) + (256 * (color->green / 256)) + (color->blue / 256);
  return result; 
}


ustring color_decimal_to_hex (unsigned int colour)
{
  gchar * s = g_strdup_printf ("%06X", colour);
  ustring result (s);
  g_free (s);
  return result;
}


ustring color_xslfo (unsigned int color)
{
  ustring result;
  if (color == 0) return result;
  result = " color=\"#000000\"";
  replace_text (result, "000000", color_decimal_to_hex (color));
  return result;
}


ustring color_odt (unsigned int color)
{
  ustring line;
  if (color != 0) {
    line = " fo:color=\"#000000\"";
    replace_text (line, "000000", color_decimal_to_hex (color));
  }
  return line;
}
