/*  beef - Flexible Brainfuck interpreter
 *  Copyright (C) 2005-2007  KiyuKo <eof AT kiyuko DOT org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Homepage: http://www.kiyuko.org/beef
 */

#include "beef.h"

/* Create a new cell on the left of the current one, and set its content to
 * \0 (empty) */
struct tape_cell *new_cell ()
{
  struct tape_cell *new;
  new = (struct tape_cell *) malloc (sizeof (struct tape_cell));
  if (new != NULL) {
    new->content = '\0';
    new->previous = NULL;
    new->next = NULL;
    return new;
  }
  else {
    fprintf (stderr, "%s: Unable to allocate memory\n", PROGRAM_NAME);
    exit (-1);
  }
}

