#!/bin/bash
# -*- shell-script -*-

# Test _Dbg_glob_filename
test_glob_filename()
{
    typeset filename

    filename=''
    _Dbg_glob_filename ${srcdir}shunit2
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ./${srcdir}shunit?
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ./${srcdir}[a-s]h*nit?
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ${srcdir}abcdefg
    assertEquals '1' $?
    filename=${filename##*/}  
    assertEquals 'abcdefg' "$filename"

    if [[ -r ~ ]] ; then
	_Dbg_glob_filename '~'
	assertEquals '0' $?
	assertEquals ~ "$filename"
    fi

    _Dbg_glob_filename ${srcdir}'some embedded spaces'
    assertEquals '1' $?
    filename=${filename##*/}  
    assertEquals 'some embedded spaces' "$filename"
    
}

# Test _Dbg_adjust_filename
test_adjust_filename()
{
    typeset filename
    _Dbg_annotate=0
    _Dbg_basename=0
    filename=$(_Dbg_adjust_filename abc)
    assertEquals 'abc' $filename
    filename=$(_Dbg_adjust_filename /abc)
    assertEquals '/abc' $filename
    _Dbg_basename_only=1
    filename=$(_Dbg_adjust_filename /abc)
    assertEquals 'abc' $filename
}

# Test _Dbg_glob_filename
test_resolve_expand_filename()
{
    filename=$(_Dbg_resolve_expand_filename /)
    assertEquals '0' $?
    assertEquals '/' "$filename"
    filename=$(_Dbg_resolve_expand_filename .)
    assertEquals '0' $?
    assertEquals '/' "${filename:0:1}"
    filename=$(_Dbg_resolve_expand_filename ./fdafdsa)
    assertEquals '0' $?
    typeset -i size=${#filename}
    assertEquals '/fdafdsa' "${filename:$size-8}"
    assertNotEquals '.' "${filename:$size-1}"
}

abs_top_srcdir=/src/external-vcs/bashdb
abs_top_srcdir=${abs_top_srcdir%%/}/

srcdir=.
srcdir=${srcdir%%/}/

_Dbg_libdir=$abs_top_srcdir
set -- -q  # Don't need to show banner
. $abs_top_srcdir/dbg-pre.sh
. $abs_top_srcdir/lib/fns.sh
. $abs_top_srcdir/lib/file.sh

# load shunit2
. ${abs_top_srcdir}/test/unit/shunit2


