# Balazar
# Copyright (C) 2003 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import soya
from soya import Point, Vector

import balazar, balazar.base as base

class Building(soya.World, base.Entity):
  pass

class Market(Building, base.Terraformer):
  radius           = 10.0
  terraform_radius = 10.0
  def __init__(self, parent = None):
    Building.__init__(self, parent)
    base.DecorativeEntity(self, soya.Shape.get("marchee_etalage"))
    
class Farm(Building, base.Photographiable, base.Terraformer):
  radius           = 5.5
  terraform_radius = 5.5
  def __init__(self, parent = None):
    Building.__init__(self, parent, soya.Shape.get("ferme"))
    #Building.__init__(self, parent, soya.Shape.get("scn-village-house"))
    #Building.__init__(self, parent, soya.Shape.get("scn-high-house"))
    
  def add_grid(self, Grid = None, typ = 1):
    self.grid = (Grid or balazar.trap.Grid)(size = "2_4", typ = typ)
    self.add(self.grid)
    self.grid.set_xyz(2.8, 0.1, 1.616)
    self.grid.rotate_lateral(90.0)
    self.parent.add_mobile(self.grid)
    return self.grid
    
  
class Altar(soya.Volume, base.Terraformer):
  terraform_radius = 6.0
  radius           = 6.0
  def __init__(self, parent = None):
    soya.Volume.__init__(self, parent, soya.Shape.get("altar1"))
    self.scale(3.0, 3.0, 3.0)
    
    
class Vigie(Building, base.Photographiable):
  radius           = 4.8
  def __init__(self, parent = None):
    Building.__init__(self, parent, soya.Shape.get("vigie"))
    
class MovingVigie(Building, base.Photographiable):
  radius           = 4.8
  def __init__(self, parent = None):
    Building.__init__(self, parent, soya.Shape.get("vigie"))
    
    self.direction = -1
    self.count     = 0
    
  def begin_round(self):
    self.count += 1
    if self.count == 82:
      self.direction = -self.direction
      self.count     = 0
      
  def advance_time(self, proportion):
    self.y += proportion * self.direction * 0.2
        
    
class RotatingVigie(Building, base.Photographiable):
  radius           = 4.8
  def __init__(self, parent = None):
    Building.__init__(self, parent, soya.Shape.get("vigie"))
    
  def advance_time(self, proportion):
    self.rotate_lateral(proportion * 6.0)
        
    
class Tower(Building, base.Photographiable, base.Terraformer):
  radius           = 4.0
  terraform_radius = 3.0
  def __init__(self, parent = None):
    Building.__init__(self, parent, soya.Shape.get("tour"))
  


class Temple(Building, base.Photographiable, base.Terraformer):
  radius           = 10.0
  terraform_radius = 8.0
  def __init__(self, parent = None):
    Building.__init__(self, parent)
    self.shape = soya.Shape.get("marchee")
    
    
  def add_grid(self, Grid = None, typ = 1):
    self.grid = (Grid or balazar.trap.Grid)(size = "4_8", typ = typ)
    self.add(self.grid)
    self.grid.set_xyz(-6.75, 0.0, -2.067)
    self.grid.rotate_lateral(90.0)
    self.parent.add_mobile(self.grid)
    return self.grid
      
# class MorkulTemple(Building, base.Photographiable, base.Terraformer):
#   radius           = 10.0
#   terraform_radius = 3.0
#   def __init__(self, parent = None):
#     Building.__init__(self, parent)
#     base.DecorativeEntity(self, soya.Shape.get("temple_morkul"))

