/* Test of scanf(): float conversion.
   $Id: sscanf_flt-f1.c,v 1.1.2.3 2008/03/20 21:42:36 joerg_wunsch Exp $	*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "progmem.h"

#ifdef	__AVR__
# define ASSERT(expr)			\
    do {				\
	if (!(expr)) exit(__LINE__);	\
    } while (0)
# define EXIT(v)	exit (v)
# if defined(__AVR_ATmega128__)
  /* ATmega128 has enough RAM for sprintf(), print to 0x2000 in XRAM. */
#  define PRINTF(f...)	sprintf((char *)0x2000, f)
# else
  /* small AVR */
#  define PRINTF(f...)
# endif
#else
# include <assert.h>
# define ASSERT(expr)	assert (expr)
# define EXIT(v)	exit ((v) < 256 ? (v) : 255)
# define PRINTF(f...)	printf (f)
# define sscanf_P	sscanf
# define memcmp_P	memcmp
#endif

/* Next variables are useful to debug the AVR.	*/
int vrslt = 1;
struct {
    float x[7];
    char c[7];
} v = { {1.0}, {1} };

void Check (int line, int expval, int rslt)
{
    vrslt = rslt;
    if (rslt != expval) {
	PRINTF ("\nLine %d:  expect= %d, rslt= %d\n", line, expval, rslt);
	EXIT (line);
    }
}

/* The sscanf() is called 4 times: SRAM and FLASH format, 2 values
   to fill before run.	*/
#define CHECK(expval, ass_expr, str, fmt, ...)				\
    do {								\
	PROGMEM static char fmt_p[] = fmt;				\
	char str_s[220];						\
	char fmt_s[40];							\
	char FILL;							\
	int i;								\
	int (* volatile vp)(const char *, const char *, ...);		\
									\
	ASSERT (sizeof(str_s) >= sizeof(str));				\
	ASSERT (sizeof(fmt_s) >= sizeof(fmt_p));			\
	strcpy_P (str_s, PSTR(str));					\
	strcpy_P (fmt_s, fmt_p);					\
									\
	for (FILL = 0; FILL < 4; FILL++) {				\
	    memset (&v, FILL, sizeof(v));				\
	    vp = (FILL & 1) ? sscanf_P : sscanf;			\
	    i = vp (str_s, (FILL & 1) ? fmt_p : fmt_s, ##__VA_ARGS__);	\
	    Check (__LINE__, expval, i);				\
    	    ASSERT (ass_expr);						\
	}								\
    } while (0)

int main ()
{
    /* All possible conversion symbols.	*/
    CHECK (
	6,
	v.x[0] == 1.0 && v.x[1] == 2.0 && v.x[2] == 3.0
	&& v.x[3] == 4.0 && v.x[4] == 5.0 && v.x[5] == 6.0,
	"1 2 3 4 5 6", "%e %E %f %F %g %G",
	& v.x[0], & v.x[1], & v.x[2], & v.x[3], & v.x[4], & v.x[5]);

    /* Empty input.	*/
    CHECK (-1, (*(char *)v.x == FILL), "", "%e", v.x);
    CHECK (-1, (*(char *)v.x == FILL), "", " %e", v.x);
    CHECK (-1, (*(char *)v.x == FILL), " ", " %e", v.x);
    CHECK (-1, (*(char *)v.x == FILL), " ", "  %e", v.x);
    CHECK (-1, (*(char *)v.x == FILL), "\t\n\v\f\r", " %e", v.x);

    /* 0.0	*/
    CHECK (
	6,
	v.x[0] == 0.0 && v.x[1] == 0.0 && v.x[2] == 0.0
	&& v.x[3] == 0.0 && v.x[4] == 0.0 && v.x[5] == 0.0,
	"0 0. .0 0.0 +0 +0.0", "%e %e %e %e %e %e",
	& v.x[0], & v.x[1], & v.x[2], & v.x[3], & v.x[4], & v.x[5]);

    /* -0.0	*/
    CHECK (
	6,
	v.x[0] == -0.0 && v.x[1] == -0.0 && v.x[2] == -0.0
	&& v.x[3] == -0.0 && v.x[4] == -0.0 && v.x[5] == -0.0,
	"-0 -0. -.0 -0.0 -00 -0e+00", "%e %e %e %e %e %e",
	& v.x[0], & v.x[1], & v.x[2], & v.x[3], & v.x[4], & v.x[5]);

    /* End of number.	*/
    CHECK (
	12,
	v.x[0] == 123 && v.c[0] == ' '
	&& v.x[1] == 456 && v.c[1] == '\001'
	&& v.x[2] == 789 && v.c[2] == '\377'
	&& v.x[3] == 12. && v.c[3] == '/'
	&& v.x[4] == 345 && v.c[4] == ':'
	&& v.x[5] == 678 && v.c[5] == 'd',
	"123 456\001789\377012/345:678d+11",
	"%e%c %e%c %e%c %e%c %e%c %e%c",
	& v.x[0], & v.c[0], & v.x[1], & v.c[1], & v.x[2], & v.c[2],
	& v.x[3], & v.c[3], & v.x[4], & v.c[4], & v.x[5], & v.c[5]);

    CHECK (
	12,
	v.x[0] == 234 && v.c[0] == '.'
	&& v.x[1] == 567 && v.c[1] == '+'
	&& v.x[2] == 890 && v.c[2] == '-'
	&& v.x[3] == 123 && v.c[3] == 'f'
	&& v.x[4] == 456 && v.c[4] == '\177'
	&& v.x[5] == 0.5 && v.c[5] == '.',
	"234..567+890-123f+456\1770.5.",
	"%e%c %e%c %e%c %e%c %e%c %e%c",
	& v.x[0], & v.c[0], & v.x[1], & v.c[1], & v.x[2], & v.c[2],
	& v.x[3], & v.c[3], & v.x[4], & v.c[4], & v.x[5], & v.c[5]);

    return 0;
}
