/* awn-app.c generated by valac 0.10.4, the Vala compiler
 * generated from awn-app.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include "awn-panel.h"
#include <libdesktop-agnostic/config.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>


#define AWN_TYPE_APP_DBUS_INTERFACE (awn_app_dbus_interface_get_type ())
#define AWN_APP_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AWN_TYPE_APP_DBUS_INTERFACE, AwnAppDBusInterface))
#define AWN_IS_APP_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AWN_TYPE_APP_DBUS_INTERFACE))
#define AWN_APP_DBUS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AWN_TYPE_APP_DBUS_INTERFACE, AwnAppDBusInterfaceIface))

typedef struct _AwnAppDBusInterface AwnAppDBusInterface;
typedef struct _AwnAppDBusInterfaceIface AwnAppDBusInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _AwnAppDBusInterfaceDBusProxy AwnAppDBusInterfaceDBusProxy;
typedef DBusGProxyClass AwnAppDBusInterfaceDBusProxyClass;

#define AWN_TYPE_APPLICATION (awn_application_get_type ())
#define AWN_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AWN_TYPE_APPLICATION, AwnApplication))
#define AWN_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AWN_TYPE_APPLICATION, AwnApplicationClass))
#define AWN_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AWN_TYPE_APPLICATION))
#define AWN_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AWN_TYPE_APPLICATION))
#define AWN_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AWN_TYPE_APPLICATION, AwnApplicationClass))

typedef struct _AwnApplication AwnApplication;
typedef struct _AwnApplicationClass AwnApplicationClass;
typedef struct _AwnApplicationPrivate AwnApplicationPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _AwnAppDBusInterfaceIface {
	GTypeInterface parent_iface;
	char** (*get_panels) (AwnAppDBusInterface* self, int* result_length1, GError** error);
	void (*remove_panel) (AwnAppDBusInterface* self, gint panel_id, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _AwnAppDBusInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _AwnApplication {
	GObject parent_instance;
	AwnApplicationPrivate * priv;
};

struct _AwnApplicationClass {
	GObjectClass parent_class;
};

struct _AwnApplicationPrivate {
	GHashTable* panels;
	DBusGConnection* connection;
	DesktopAgnosticConfigClient* client;
};


static AwnApplication* awn_application_instance;
static AwnApplication* awn_application_instance = NULL;
static gpointer awn_application_parent_class = NULL;
static AwnAppDBusInterfaceIface* awn_application_awn_app_dbus_interface_parent_iface = NULL;

AwnAppDBusInterface* awn_app_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType awn_app_dbus_interface_get_type (void) G_GNUC_CONST;
char** awn_app_dbus_interface_get_panels (AwnAppDBusInterface* self, int* result_length1, GError** error);
void awn_app_dbus_interface_remove_panel (AwnAppDBusInterface* self, gint panel_id, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void awn_app_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _awn_app_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult awn_app_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_awn_app_dbus_interface_introspect (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_awn_app_dbus_interface_property_get_all (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_awn_app_dbus_interface_get_panels (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_awn_app_dbus_interface_remove_panel (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_awn_app_dbus_interface_panel_added (GObject* _sender, gint panel_id, DBusConnection* _connection);
static void _dbus_awn_app_dbus_interface_panel_removed (GObject* _sender, gint panel_id, DBusConnection* _connection);
GType awn_app_dbus_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_awn_app_dbus_interface_panel_added (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_awn_app_dbus_interface_panel_removed (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult awn_app_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	AWN_APP_DBUS_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static char** awn_app_dbus_interface_dbus_proxy_get_panels (AwnAppDBusInterface* self, int* result_length1, GError** error);
static void awn_app_dbus_interface_dbus_proxy_remove_panel (AwnAppDBusInterface* self, gint panel_id, GError** error);
static void awn_app_dbus_interface_dbus_proxy_awn_app_dbus_interface__interface_init (AwnAppDBusInterfaceIface* iface);
static void awn_app_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void awn_app_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType awn_application_get_type (void) G_GNUC_CONST;
#define AWN_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AWN_TYPE_APPLICATION, AwnApplicationPrivate))
enum  {
	AWN_APPLICATION_DUMMY_PROPERTY
};
static AwnApplication* awn_application_new (void);
static AwnApplication* awn_application_construct (GType object_type);
static void awn_application_panels_changed (AwnApplication* self, const char* key, const char* group, GValue* val);
static void _awn_application_panels_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
static char** awn_application_real_get_panels (AwnAppDBusInterface* base, int* result_length1, GError** error);
static void awn_application_real_remove_panel (AwnAppDBusInterface* base, gint panel_id, GError** error);
AwnApplication* awn_application_get_default (void);
void awn_application_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _awn_application_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult awn_application_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_awn_application_introspect (AwnApplication* self, DBusConnection* connection, DBusMessage* message);
static void awn_application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _awn_app_dbus_interface_dbus_path_vtable = {_awn_app_dbus_interface_dbus_unregister, awn_app_dbus_interface_dbus_message};
static const _DBusObjectVTable _awn_app_dbus_interface_dbus_vtable = {awn_app_dbus_interface_dbus_register_object};
static const DBusObjectPathVTable _awn_application_dbus_path_vtable = {_awn_application_dbus_unregister, awn_application_dbus_message};
static const _DBusObjectVTable _awn_application_dbus_vtable = {awn_application_dbus_register_object};


char** awn_app_dbus_interface_get_panels (AwnAppDBusInterface* self, int* result_length1, GError** error) {
	return AWN_APP_DBUS_INTERFACE_GET_INTERFACE (self)->get_panels (self, result_length1, error);
}


void awn_app_dbus_interface_remove_panel (AwnAppDBusInterface* self, gint panel_id, GError** error) {
	AWN_APP_DBUS_INTERFACE_GET_INTERFACE (self)->remove_panel (self, panel_id, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _awn_app_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_awn_app_dbus_interface_introspect (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.awnproject.Awn.App\">\n  <method name=\"GetPanels\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"RemovePanel\">\n    <arg name=\"panel_id\" type=\"i\" direction=\"in\"/>\n  </method>\n  <signal name=\"PanelAdded\">\n    <arg name=\"panel_id\" type=\"i\"/>\n  </signal>\n  <signal name=\"PanelRemoved\">\n    <arg name=\"panel_id\" type=\"i\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_awn_app_dbus_interface_property_get_all (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.awnproject.Awn.App") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_awn_app_dbus_interface_get_panels (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = awn_app_dbus_interface_get_panels (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		const char* _tmp4_;
		_tmp4_ = *_tmp1_;
		dbus_message_iter_append_basic (&_tmp2_, DBUS_TYPE_STRING, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_awn_app_dbus_interface_remove_panel (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint panel_id = 0;
	dbus_int32_t _tmp5_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	panel_id = _tmp5_;
	awn_app_dbus_interface_remove_panel (self, panel_id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult awn_app_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_awn_app_dbus_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_awn_app_dbus_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.awnproject.Awn.App", "GetPanels")) {
		result = _dbus_awn_app_dbus_interface_get_panels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.awnproject.Awn.App", "RemovePanel")) {
		result = _dbus_awn_app_dbus_interface_remove_panel (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_awn_app_dbus_interface_panel_added (GObject* _sender, gint panel_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_int32_t _tmp6_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.awnproject.Awn.App", "PanelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp6_ = panel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp6_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_awn_app_dbus_interface_panel_removed (GObject* _sender, gint panel_id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_int32_t _tmp7_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.awnproject.Awn.App", "PanelRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp7_ = panel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp7_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void awn_app_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_awn_app_dbus_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "panel-added", (GCallback) _dbus_awn_app_dbus_interface_panel_added, connection);
	g_signal_connect (object, "panel-removed", (GCallback) _dbus_awn_app_dbus_interface_panel_removed, connection);
}


static void awn_app_dbus_interface_base_init (AwnAppDBusInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("panel_added", AWN_TYPE_APP_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
		g_signal_new ("panel_removed", AWN_TYPE_APP_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
		g_type_set_qdata (AWN_TYPE_APP_DBUS_INTERFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_awn_app_dbus_interface_dbus_vtable));
	}
}


GType awn_app_dbus_interface_get_type (void) {
	static volatile gsize awn_app_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&awn_app_dbus_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AwnAppDBusInterfaceIface), (GBaseInitFunc) awn_app_dbus_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType awn_app_dbus_interface_type_id;
		awn_app_dbus_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "AwnAppDBusInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (awn_app_dbus_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (awn_app_dbus_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &awn_app_dbus_interface_dbus_proxy_get_type);
		g_once_init_leave (&awn_app_dbus_interface_type_id__volatile, awn_app_dbus_interface_type_id);
	}
	return awn_app_dbus_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (AwnAppDBusInterfaceDBusProxy, awn_app_dbus_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (AWN_TYPE_APP_DBUS_INTERFACE, awn_app_dbus_interface_dbus_proxy_awn_app_dbus_interface__interface_init) );
AwnAppDBusInterface* awn_app_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	AwnAppDBusInterface* self;
	self = g_object_new (awn_app_dbus_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.awnproject.Awn.App", NULL);
	return self;
}


static GObject* awn_app_dbus_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (awn_app_dbus_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), awn_app_dbus_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='org.awnproject.Awn.App'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_awn_app_dbus_interface_panel_added (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gint panel_id = 0;
	dbus_int32_t _tmp0_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	panel_id = _tmp0_;
	g_signal_emit_by_name (self, "panel-added", panel_id);
}


static void _dbus_handle_awn_app_dbus_interface_panel_removed (AwnAppDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gint panel_id = 0;
	dbus_int32_t _tmp1_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	panel_id = _tmp1_;
	g_signal_emit_by_name (self, "panel-removed", panel_id);
}


DBusHandlerResult awn_app_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.awnproject.Awn.App", "PanelAdded")) {
			_dbus_handle_awn_app_dbus_interface_panel_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.awnproject.Awn.App", "PanelRemoved")) {
			_dbus_handle_awn_app_dbus_interface_panel_removed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void awn_app_dbus_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((AwnAppDBusInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((AwnAppDBusInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), awn_app_dbus_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (awn_app_dbus_interface_dbus_proxy_parent_class)->dispose (self);
}


static void awn_app_dbus_interface_dbus_proxy_class_init (AwnAppDBusInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = awn_app_dbus_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = awn_app_dbus_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = awn_app_dbus_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = awn_app_dbus_interface_dbus_proxy_set_property;
}


static void awn_app_dbus_interface_dbus_proxy_init (AwnAppDBusInterfaceDBusProxy* self) {
}


static char** awn_app_dbus_interface_dbus_proxy_get_panels (AwnAppDBusInterface* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	DBusMessageIter _tmp3_;
	if (((AwnAppDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.awnproject.Awn.App", "GetPanels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp5_;
			_edomain = DBUS_GERROR;
			_tmp5_ = _dbus_error.name + 27;
			if (strcmp (_tmp5_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp5_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp5_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp5_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp5_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp5_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp5_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp5_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp5_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp5_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp5_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp5_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp5_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp5_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp5_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp5_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp5_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp5_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp5_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp5_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp5_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp5_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp5_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp5_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp5_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp5_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp5_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp5_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp5_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp2_ = g_new (char*, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp3_);
	for (; dbus_message_iter_get_arg_type (&_tmp3_); _tmp2__length1++) {
		const char* _tmp4_;
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (char*, _tmp2_, _tmp2__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp3_, &_tmp4_);
		dbus_message_iter_next (&_tmp3_);
		_tmp2_[_tmp2__length++] = g_strdup (_tmp4_);
	}
	_result_length1 = _tmp2__length1;
	_tmp2_[_tmp2__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp2_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void awn_app_dbus_interface_dbus_proxy_remove_panel (AwnAppDBusInterface* self, gint panel_id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int32_t _tmp6_;
	if (((AwnAppDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.awnproject.Awn.App", "RemovePanel");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp6_ = panel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp6_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp7_;
			_edomain = DBUS_GERROR;
			_tmp7_ = _dbus_error.name + 27;
			if (strcmp (_tmp7_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp7_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp7_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp7_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp7_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp7_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp7_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp7_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp7_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp7_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp7_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp7_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp7_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp7_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp7_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp7_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp7_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp7_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp7_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp7_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp7_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp7_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp7_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp7_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp7_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp7_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp7_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp7_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp7_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp7_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp7_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp7_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp7_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void awn_app_dbus_interface_dbus_proxy_awn_app_dbus_interface__interface_init (AwnAppDBusInterfaceIface* iface) {
	iface->get_panels = awn_app_dbus_interface_dbus_proxy_get_panels;
	iface->remove_panel = awn_app_dbus_interface_dbus_proxy_remove_panel;
}


static void awn_app_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void awn_app_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _awn_application_panels_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	awn_application_panels_changed (self, group, key, value);
}


static AwnApplication* awn_application_construct (GType object_type) {
	AwnApplication * self = NULL;
	GHashTable* _tmp0_;
	DesktopAgnosticConfigClient* _tmp1_;
	DesktopAgnosticConfigClient* _tmp2_;
	DBusGConnection* _tmp3_;
	DBusGConnection* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (AwnApplication*) g_object_new (object_type, NULL);
	self->priv->panels = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->panels), _tmp0_);
	_tmp1_ = awn_config_get_default (0, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->client = (_tmp2_ = _g_object_ref0 (_tmp1_), _g_object_unref0 (self->priv->client), _tmp2_);
	gtk_window_set_default_icon_name ("avant-window-navigator");
	_tmp3_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->connection = (_tmp4_ = _tmp3_, _dbus_g_connection_unref0 (self->priv->connection), _tmp4_);
	_vala_dbus_register_object (dbus_g_connection_get_connection (self->priv->connection), "/org/awnproject/Awn", (GObject*) self);
	{
		GValueArray* panel_ids;
		panel_ids = desktop_agnostic_config_client_get_list (self->priv->client, "panels", "panel_list", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		if (panel_ids->n_values == 0) {
			gboolean is_gconf;
			GType config_type;
			const char* _tmp5_;
			is_gconf = FALSE;
			config_type = desktop_agnostic_config_get_type (&_inner_error_);
			if (_inner_error_ != NULL) {
				_g_value_array_free0 (panel_ids);
				goto __catch0_g_error;
			}
			if (config_type > 0) {
				is_gconf = strstr (g_type_name (config_type), "GConf") != NULL;
			}
			_tmp5_ = NULL;
			if (is_gconf) {
				_tmp5_ = "\n**  Please check that the gconf-schema is installed." "\n**  You might want to try running `killall gconfd-2`.";
			} else {
				_tmp5_ = "";
			}
			g_error ("awn-app.vala:66: No panels to create! %s", _tmp5_);
		}
		{
			GValueArray* val_collection;
			guint val_index;
			val_collection = panel_ids;
			for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
				GValue _tmp7_ = {0};
				GValue val;
				val = G_IS_VALUE (g_value_array_get_nth (val_collection, val_index)) ? (g_value_init (&_tmp7_, G_VALUE_TYPE (g_value_array_get_nth (val_collection, val_index))), g_value_copy (g_value_array_get_nth (val_collection, val_index), &_tmp7_), _tmp7_) : (*g_value_array_get_nth (val_collection, val_index));
				{
					gint panel_id;
					char* path;
					AwnPanel* panel;
					char* _tmp6_;
					panel_id = g_value_get_int (&val);
					path = g_strdup_printf ("/org/awnproject/Awn/Panel%d", panel_id);
					panel = g_object_ref_sink ((AwnPanel*) awn_panel_new_with_panel_id (panel_id));
					g_hash_table_insert (self->priv->panels, (_tmp6_ = path, path = NULL, _tmp6_), _g_object_ref0 (panel));
					gtk_widget_show ((GtkWidget*) panel);
					_g_object_unref0 (panel);
					_g_free0 (path);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				}
			}
		}
		desktop_agnostic_config_client_notify_add (self->priv->client, "panels", "panel_list", _awn_application_panels_changed_desktop_agnostic_config_notify_func, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_value_array_free0 (panel_ids);
			goto __catch0_g_error;
		}
		_g_value_array_free0 (panel_ids);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("awn-app.vala:87: Unable to retrieve panels config value: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static AwnApplication* awn_application_new (void) {
	return awn_application_construct (AWN_TYPE_APPLICATION);
}


static void awn_application_panels_changed (AwnApplication* self, const char* key, const char* group, GValue* val) {
	GList* untouched_panels;
	GValueArray* arr;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (group != NULL);
	untouched_panels = NULL;
	{
		GList* p_collection;
		GList* p_it;
		p_collection = g_hash_table_get_values (self->priv->panels);
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AwnPanel* p;
			p = (AwnPanel*) p_it->data;
			{
				untouched_panels = g_list_append (untouched_panels, p);
			}
		}
		_g_list_free0 (p_collection);
	}
	arr = (GValueArray*) g_value_get_boxed (val);
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = arr;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp1_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp1_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp1_), _tmp1_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				gint panel_id;
				char* path;
				AwnPanel* p;
				panel_id = g_value_get_int (&v);
				path = g_strdup_printf ("/org/awnproject/Awn/Panel%d", panel_id);
				p = (AwnPanel*) g_hash_table_lookup (self->priv->panels, path);
				if (p == NULL) {
					AwnPanel* panel;
					char* _tmp0_;
					panel = g_object_ref_sink ((AwnPanel*) awn_panel_new_with_panel_id (panel_id));
					g_hash_table_insert (self->priv->panels, (_tmp0_ = path, path = NULL, _tmp0_), _g_object_ref0 (panel));
					gtk_widget_show ((GtkWidget*) panel);
					g_signal_emit_by_name ((AwnAppDBusInterface*) self, "panel-added", panel_id);
					_g_object_unref0 (panel);
				} else {
					untouched_panels = g_list_remove (untouched_panels, p);
				}
				_g_free0 (path);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	{
		GList* p_collection;
		GList* p_it;
		p_collection = untouched_panels;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AwnPanel* p;
			p = (AwnPanel*) p_it->data;
			{
				gint _tmp2_;
				gint panel_id;
				gint _tmp3_;
				char* path;
				panel_id = (g_object_get (p, "panel-id", &_tmp2_, NULL), _tmp2_);
				path = g_strdup_printf ("/org/awnproject/Awn/Panel%d", (g_object_get (p, "panel-id", &_tmp3_, NULL), _tmp3_));
				g_hash_table_remove (self->priv->panels, path);
				g_signal_emit_by_name ((AwnAppDBusInterface*) self, "panel-removed", panel_id);
				gtk_object_destroy ((GtkObject*) p);
				_g_free0 (path);
			}
		}
	}
	_g_list_free0 (untouched_panels);
}


static char** awn_application_real_get_panels (AwnAppDBusInterface* base, int* result_length1, GError** error) {
	AwnApplication * self;
	char** result = NULL;
	GList* keys;
	gint paths_length1;
	gint _paths_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** paths;
	gint i;
	char** _tmp4_;
	self = (AwnApplication*) base;
	keys = g_hash_table_get_keys (self->priv->panels);
	keys = g_list_sort (keys, g_strcmp0);
	paths = (_tmp1_ = g_new0 (char*, (_tmp0_ = g_list_length (keys)) + 1), paths_length1 = _tmp0_, _paths_size_ = paths_length1, _tmp1_);
	i = 0;
	{
		GList* path_collection;
		GList* path_it;
		path_collection = keys;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			const char* path;
			path = (const char*) path_it->data;
			{
				char* *_tmp2_;
				char* _tmp3_;
				_tmp2_ = &paths[i++];
				(*_tmp2_) = (_tmp3_ = g_strdup (path), _g_free0 ((*_tmp2_)), _tmp3_);
			}
		}
	}
	result = (_tmp4_ = paths, *result_length1 = paths_length1, _tmp4_);
	_g_list_free0 (keys);
	return result;
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
	_g_list_free0 (keys);
}


static void awn_application_real_remove_panel (AwnAppDBusInterface* base, gint panel_id, GError** error) {
	AwnApplication * self;
	self = (AwnApplication*) base;
	if (panel_id == 1) {
		gtk_main_quit ();
	} else {
	}
}


AwnApplication* awn_application_get_default (void) {
	AwnApplication* result = NULL;
	if (awn_application_instance == NULL) {
		AwnApplication* _tmp0_;
		awn_application_instance = (_tmp0_ = awn_application_new (), _g_object_unref0 (awn_application_instance), _tmp0_);
	}
	result = awn_application_instance;
	return result;
}


void _awn_application_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_awn_application_introspect (AwnApplication* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.awnproject.Awn.App\">\n  <method name=\"GetPanels\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"RemovePanel\">\n    <arg name=\"panel_id\" type=\"i\" direction=\"in\"/>\n  </method>\n  <signal name=\"PanelAdded\">\n    <arg name=\"panel_id\" type=\"i\"/>\n  </signal>\n  <signal name=\"PanelRemoved\">\n    <arg name=\"panel_id\" type=\"i\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult awn_application_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_awn_application_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (awn_app_dbus_interface_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void awn_application_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_awn_application_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	awn_app_dbus_interface_dbus_register_object (connection, path, object);
}


static void awn_application_class_init (AwnApplicationClass * klass) {
	awn_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AwnApplicationPrivate));
	G_OBJECT_CLASS (klass)->finalize = awn_application_finalize;
	g_type_set_qdata (AWN_TYPE_APPLICATION, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_awn_application_dbus_vtable));
}


static void awn_application_awn_app_dbus_interface_interface_init (AwnAppDBusInterfaceIface * iface) {
	awn_application_awn_app_dbus_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panels = awn_application_real_get_panels;
	iface->remove_panel = awn_application_real_remove_panel;
}


static void awn_application_instance_init (AwnApplication * self) {
	self->priv = AWN_APPLICATION_GET_PRIVATE (self);
}


static void awn_application_finalize (GObject* obj) {
	AwnApplication * self;
	self = AWN_APPLICATION (obj);
	_g_hash_table_unref0 (self->priv->panels);
	_dbus_g_connection_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->client);
	G_OBJECT_CLASS (awn_application_parent_class)->finalize (obj);
}


GType awn_application_get_type (void) {
	static volatile gsize awn_application_type_id__volatile = 0;
	if (g_once_init_enter (&awn_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AwnApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) awn_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AwnApplication), 0, (GInstanceInitFunc) awn_application_instance_init, NULL };
		static const GInterfaceInfo awn_app_dbus_interface_info = { (GInterfaceInitFunc) awn_application_awn_app_dbus_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType awn_application_type_id;
		awn_application_type_id = g_type_register_static (G_TYPE_OBJECT, "AwnApplication", &g_define_type_info, 0);
		g_type_add_interface_static (awn_application_type_id, AWN_TYPE_APP_DBUS_INTERFACE, &awn_app_dbus_interface_info);
		g_once_init_leave (&awn_application_type_id__volatile, awn_application_type_id);
	}
	return awn_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




