/****************************************************************
**
** Attal : Lords of Doom
**
** tavern.cpp
** Manage tavern building
**
** Version : $Id: tavern.cpp,v 1.14 2007/09/06 16:38:29 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 04/02/2005
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "tavern.h"
 
// generic include files
// include files for QT
#include <QHBoxLayout>
#include <QLabel>
#include <QLayout>
#include <QPushButton>
#include <QSignalMapper>
#include <QVBoxLayout>

#include <QScrollArea>
// application specific include files
#include "libCommon/attalSocket.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"

#include "libClient/attalButton.h"
#include "libClient/gui.h"
#include "libClient/imageTheme.h"
#include "libClient/widget.h"

//
// ----- Tavern -----
//

Tavern::Tavern( QWidget * parent )
: QDialog( parent, Qt::Dialog )
{
	_player = 0;
	_base = 0;
	
	_signalMapper = 0;
	
	QLabel * labIntro = new QLabel( this );
	labIntro->setWordWrap( true );	
	labIntro->setText( "Some lords are visiting your base and are available in your tavern. Here is the list:" );
	
	
	AttalButton * pbOk = new AttalButton( this, AttalButton::BT_OK );
	
	QHBoxLayout * layHOk = new QHBoxLayout();
	layHOk->addStretch( 1 );
	layHOk->addWidget( pbOk );
	layHOk->addStretch( 1 );
	
	_scroll = new QScrollArea( this );
	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setSpacing( 5 );
	layout->setMargin( 5 );
	layout->addWidget( labIntro );
	layout->addWidget( _scroll, 1 );
	layout->addLayout( layHOk );
	layout->activate();
	
	connect( pbOk, SIGNAL( clicked() ), SLOT( accept() ) );
	
	resize( 400, 300 );
}

Tavern::~Tavern()
{
	while( ! _lords.isEmpty() ) {
		delete _lords.takeFirst();
	}
}

void Tavern::initSocket( AttalSocket * socket )
{
	_socket = socket;
}

void Tavern::initPlayer( GenericPlayer * player )
{
	_player = player;
}

void Tavern::handleSocket()
{
	if( ( _socket->getCla1() == SO_GAME ) and ( _socket->getCla2() == C_GAME_TAVERN ) ) {
		switch( _socket->getCla3() ) {
		case C_TAVERN_INFO:
			handleTavernInfo();
			break;
		case C_TAVERN_LORD:
			handleTavernLord();
			break;
		default:
			logEE( "Should not happen" );
		}	
	}
}

void Tavern::handleTavernInfo()
{
	_nbLord = _socket->readChar();
	_nbLordRead = 0;
	
	while( ! _lords.isEmpty() ) {
		delete _lords.takeFirst();
	}
	if( _signalMapper ) {
		delete _signalMapper;
	}
	_signalMapper = new QSignalMapper( this );
	connect( _signalMapper, SIGNAL( mapped( int ) ), SLOT( slot_buy( int ) ) );
	if( _nbLordRead >= _nbLord ) {
		QDialog::exec();
	} else {
		_socket->askTavernLord( _base, _nbLordRead );
	}
}

void Tavern::handleTavernLord()
{
	_nbLordRead++;
	/// XXX: reads lord info and displays it
	uint idLord = _socket->readInt();
	GenericLord * lord = new GenericLord();
	lord->setId( idLord );
	TavernLord * widget = new TavernLord( _scroll->viewport() );
	widget->initPlayer( _player ) ;
	widget->init( lord );
	_signalMapper->setMapping( widget, _lords.count() );
	_lords.append( widget );
	_scroll->setWidget( widget );
	widget->resize( 400, 70);
	connect( widget, SIGNAL( sig_buy() ), _signalMapper, SLOT( map() ) );
	if( _nbLordRead >= _nbLord ) {
		QDialog::exec();
	}
}

void Tavern::start( GenericBase * base )
{
	_base = base;
	/// XXX: test if we need ask server info...
	_socket->askTavernInfo( base );
}

void Tavern::restart()
{
	_socket->askTavernInfo( _base );
}

void Tavern::slot_buy(  int numLord )
{
	if(_player && _socket && _lords.value( numLord ) && _base) {
			/// XXX: not finished
		if(_player->canBuy(DataTheme.lords.at(numLord)) && !_base->isVisitorLord()) {
			int col = _base->getCell()->getCol();
			int row = _base->getCell()->getRow();
			//logDD(" row %d ,col %d", row, col);
			_socket->sendLordBuy( _lords.at(numLord)->getLord() , row, col);
			TRACE( "buy %d", numLord );
		}
	}
}

//
// ----- TavernLord -----
//

TavernLord::TavernLord( QWidget * parent )
: QWidget( parent )
{
	_player = 0;
	_lord = 0;
	_photo = new Icon( this );
	
	_info = new QLabel( this );
	_price = new QLabel( this );
	
	QVBoxLayout * layV1 = new QVBoxLayout();
	layV1->setMargin( 5 );
	layV1->setSpacing( 5 );
	layV1->addWidget( _info );
	layV1->addWidget( _price );
	layV1->addStretch( 1 );
	
	_pbBuy = new QPushButton( this );
	_pbBuy->setText( tr( "Buy" ) );
	FIXEDSIZE( _pbBuy );
	
	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->setSpacing( 5 );
	layout->setMargin( 5 );
	layout->addWidget( _photo );
	layout->addLayout( layV1,1 );
	layout->addWidget( _pbBuy );
	layout->activate();
	
	connect( _pbBuy, SIGNAL( clicked() ), this, SIGNAL( sig_buy() ) );
}

TavernLord::~TavernLord()
{
	if(_lord){
		delete _lord;
		_lord = NULL;
	}
}

void TavernLord::initPlayer( GenericPlayer * player )
{
	_player = player;
}

void TavernLord::init( GenericLord * lord )
{
	_pbBuy->setEnabled( false );
	QString temp;
	if(_lord){
		delete _lord;
		_lord = NULL;
	}
	_lord = lord;


	if( ImageTheme.getLordPixmap( lord->getId() ) ) {
		_photo->setPixmap( * ImageTheme.getLordPixmap( lord->getId() ) );
	}

	temp.sprintf( "Lord %s (%s)", lord->getName().toLatin1().constData(), lord->getCategoryName().toLatin1().constData() );
	_info->setText( temp );
	FIXEDSIZE( _info );
	GenericLordModel * lordModel = DataTheme.lords.at(_lord->getId());
	
	if(_player) {
		if(_player->canBuy(lordModel)) {
			_pbBuy->setEnabled( true );
		}
	}

	_price->setText( lordModel->getLordDescription() );
	FIXEDSIZE( _price );
}



