#!/bin/sh 

set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
version=`dpkg-parsechangelog | sed -n 's/^Version: \(.*\)-.*/\1/p'`
tarball=$3
TAR=${package}_${version}.orig.tar.gz
DIR=${package}-${version}.orig

unzip $tarball -d $DIR
unzip $DIR/javax.inject-src.zip -d $DIR

GZIP=--best tar --numeric --group 0 --owner 0 -c -v -z -f $TAR \
    --exclude '*.zip' --exclude '*.jar' $DIR

rm -rf $tarball $DIR
