# -*- mode: python; coding: utf-8 -*-

# unittest python plugin for atheist
#
# Copyright (C) 2010 Oscar Aceña
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import sys, unittest, inspect

import atheist

class UnitTask(atheist.Task):
    acro = 'Unit'
    allows = ['check', 'cwd', 'delay', 'desc', 'expected', 'must_fail']

    def __init__(self, utest, name, **kargs):
        assert callable(utest)
        self.utest = utest

        atheist.Task.__init__(self, **kargs)  #  name[len("test"):]


    def exec_task(self):
        sys.stdout = self.outwrap
        sys.stderr = self.errwrap

        try:
            tr = unittest.TestResult()
            self.utest(tr)

            if tr.wasSuccessful():
                self.result = atheist.OK

            # to Unittest failures are caused by incorrect results
            # and errors are caused by incorrect code
            elif tr.errors:
                sys.stderr.write(tr.errors[0][1])
                self.result = atheist.FAIL

            elif tr.failures:
                sys.stderr.write(tr.failures[0][1])
                self.result = atheist.ERROR

        finally:
            sys.stdout = sys.__stdout__
            sys.stderr = sys.__stderr__


#FIXME: generar automáticamente a partir de ficheros que contienen unittest.TestCase
# como hace trial, py.test o python2.7. Quizá se podría usar trial.
class UnitTestCase(atheist.CompositeTask):
    acro = 'UCas'

    def __init__(self, klass):
        if not issubclass(klass, unittest.TestCase):
            raise TypeError, "Test cases should be derived from unitest.TestCase"

        methods = [x for x in inspect.getmembers(klass, inspect.ismethod) if
                   x[0].startswith("test")]

        children = []

        for name,method in methods:
            doc = (": " + method.__doc__.split("\n")[0]) if method.__doc__ else ""
            children.append(UnitTask(klass(name),
                                     name,
                                     desc="%s.%s%s" % (klass.__name__,
                                                       name, doc.strip())))

        atheist.CompositeTask.__init__(self, all, *children)
        self.desc = "%s" % (klass.__name__)
#                                ', '.join([x[0] for x in methods]))
