#!/usr/bin/python2.5
# -*- mode: python; coding: utf-8 -*-

# atheist
#
# Copyright (C) 2009,2010 David Villa Alises
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys
import signal
import time

from pyarco.UI import ProgressBar, cout

import atheist
from atheist.manager import Manager
from atheist.gvar import Log

mgr = None

def main(argv):
    global mgr

    if not os.path.exists(atheist.const.ATHEIST_TMP):
        os.mkdir(atheist.const.ATHEIST_TMP)


    mgr = Manager(argv[1:])

    if mgr.config.clean_only:
        atheist.clean_generated()
        return


    mgr.reload()
    if len(mgr) == 0:
        Log.warning("No testfiles found.")
        return


    if mgr.config.describe:
        for t in mgr.itertasks():
            print(t.describe().encode('utf-8'))
        return


    if mgr.config.list_only:
        for case in mgr.itercases():
            print(case.fname)
            for task in case.tasks:
                print('   %s' % task)
        return

    #--

    reporters = []
    if not mgr.config.quiet:
        reporters.append(atheist.ConsoleSummaryReporter(mgr.config))

    #--

    i = 0
    tini = time.time()
    while 1:
        pb = ProgressBar(len(mgr),
                         width=int(mgr.config.screen_width),
                         label='Run ',
                         disable= mgr.config.verbosity or \
                             mgr.config.quiet or \
                             mgr.config.stdout or \
                             mgr.config.stderr)

        pb.listen_logger(Log, mgr.config.loglevel)

        mgr.run(pb.inc)

        pb.clean()

        if mgr.config.until_failure and mgr.ALL():
            print "ALL OK, repeat until failure: %s: %s tasks" % (i, mgr.ntests)
            atheist.clean_generated()
            i += 1
            time.sleep(0.5)
        else:
            break

        if mgr.abort:
            break

    # FIXME: Make reporters pluggable
    for i in mgr.config.jabber:
        reporters.append(atheist.JabberSummaryReporter(i))
    for i in mgr.config.mail:
        reporters.append(atheist.MailSummaryReporter(i))

    for n in reporters:
        n.update(mgr)

    #--

    if mgr.ntests:
        print("Total: %s" % mgr.str_stats())

    if mgr.config.until_failure:
        minutes = (time.time() - tini) / 60
        print('%s: Ran %s tasks in %.2f minutes, %.2f tasks/minute' % (
                time.asctime(), mgr.ntests, minutes, mgr.ntests/minutes))

    return mgr.fail


def abort_handler(sign, frame):
    print()
    Log.warning("C-c pressed!")
    mgr.abort = True


if __name__ == '__main__':

    signal.signal(signal.SIGPIPE, signal.SIG_DFL)
    signal.signal(signal.SIGINT, abort_handler)
    signal.signal(signal.SIGTERM, abort_handler)

    sys.exit(main(sys.argv))


