/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "environment.h"
#include "globaldata.h"
#include "decor.h"

DECOR::DECOR ()
{
	_align = LEFT;
	_current.x = 0;
	_current.y = 0;
	_current.w = 0;
	_current.h = 0;
}

DECOR::~DECOR ()
{
	_env->removeObject (this);
}

DECOR::DECOR (GLOBALDATA *global, ENVIRONMENT *env, double xpos, double ypos, double xvel, double yvel, int maxRadius, int decorType)
{
	type = decorType;
	initialise ();
	setEnvironment (env);
	player = NULL;
	_align = LEFT;
	_global = global;
	x = xpos;
	y = ypos;
	xv = xvel;
	yv = yvel;
	if (maxRadius <= 3)
		radius = 3;
	else
		radius = 3 + (rand () % (maxRadius - 3));
}

void DECOR::initialise ()
{
	PHYSICAL_OBJECT::initialise ();
	physics = 0;
	age = 0;
	if (type == DECOR_SMOKE) {
		int tempCol = 128 + (rand () % 64);
		color = makecol (tempCol, tempCol, tempCol);
		mass = 1 + ((double)(rand () % 5) / 10);
		drag = 0.9 + ((double)(rand () % 90) / 100);
		maxAge = 20 + (rand () % 90);
	}
}

int DECOR::applyPhysics ()
{
	age++;

	if (!physics) {
		double xaccel = (_env->wind - xv) / mass * drag * _env->viscosity;
		xv += xaccel;
		x += xv;
		if (x < 1 || x > (_global->screenWidth-1)) {
			destroy = TRUE;
		}
		double yaccel = (-1 - yv) / mass * drag * _env->viscosity;
		yv += yaccel;
		if (y + yv >= _global->screenHeight) {
			yv = -yv * 0.5;
			xv *= 0.95;
		}
		y += yv;
	}
	if (age > maxAge) {
		destroy = TRUE;
	}

	return (hitSomething);
}


void DECOR::draw (BITMAP *dest)
{
	if (!destroy) {
		drawing_mode (DRAW_MODE_TRANS, NULL, 0, 0);
		set_trans_blender (0, 0, 0, 255 - (255 * age / maxAge));
		circlefill (dest, (int)x, (int)y, radius, color);
		drawing_mode (DRAW_MODE_SOLID, NULL, 0, 0);
		setUpdateArea ((int)x - (radius * 2) - 1, (int)y - (radius * 2) - 1, radius * 4 + 2, radius * 4 + 2);
		requireUpdate ();
	}
}

int DECOR::isSubClass (int classNum)
{
	if (classNum == DECOR_CLASS)
		return (TRUE);
	else
		return (FALSE);
}
