/*
 * Copyright (C) 2004-2005 by Objective Systems, Inc.
 *
 * This software is furnished under an open source license and may be 
 * used and copied only in accordance with the terms of this license. 
 * The text of the license may generally be found in the root 
 * directory of this installation in the COPYING file.  It 
 * can also be viewed online at the following URL:
 *
 *   http://www.obj-sys.com/open/license.html
 *
 * Any redistributions of this file including modified versions must 
 * maintain this copyright notice.
 *
 *****************************************************************************/
/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 5.72, Date: 22-Mar-2005.
 */
#include "ooasn1.h"
#include "H235-SECURITY-MESSAGES.h"
#include "eventHandler.h"

/**************************************************************/
/*                                                            */
/*  ChallengeString                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ChallengeString (OOCTXT* pctxt, H235ChallengeString* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 8, 128, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimeStamp                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235TimeStamp (OOCTXT* pctxt, H235TimeStamp* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUnsigned (pctxt, pvalue, 1U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RandomVal                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235RandomVal (OOCTXT* pctxt, H235RandomVal* pvalue)
{
   int stat = ASN_OK;

   stat = decodeUnconsInteger (pctxt, pvalue);
   if (stat != ASN_OK) return stat;
   invokeIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Password                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235Password (OOCTXT* pctxt, H235Password* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBMPString (pctxt, pvalue, 0);
   if (stat != ASN_OK) return stat;
   invokeCharStr16BitValue (pctxt, pvalue->nchars, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncodedPwdCertToken                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235EncodedPwdCertToken (OOCTXT* pctxt, H235EncodedPwdCertToken* pvalue)
{
   int stat = ASN_OK;

   stat = decodeOpenType (pctxt, &pvalue->data, &pvalue->numocts);
   if (stat != ASN_OK) return stat;
   invokeOpenTypeValue
      (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardParameter                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235NonStandardParameter (OOCTXT* pctxt, H235NonStandardParameter* pvalue)
{
   int stat = ASN_OK;

   /* decode nonStandardIdentifier */

   invokeStartElement (pctxt, "nonStandardIdentifier", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->nonStandardIdentifier);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->nonStandardIdentifier.numids, pvalue->nonStandardIdentifier.subid);

   invokeEndElement (pctxt, "nonStandardIdentifier", -1);

   /* decode data */

   invokeStartElement (pctxt, "data", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->data);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->data.numocts, pvalue->data.data);

   invokeEndElement (pctxt, "data", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AuthenticationBES                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235AuthenticationBES (OOCTXT* pctxt, H235AuthenticationBES* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* default_ */
         case 0:
            invokeStartElement (pctxt, "default_", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "default_", -1);

            break;

         /* radius */
         case 1:
            invokeStartElement (pctxt, "radius", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "radius", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AuthenticationMechanism                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235AuthenticationMechanism (OOCTXT* pctxt, H235AuthenticationMechanism* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 6);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* dhExch */
         case 0:
            invokeStartElement (pctxt, "dhExch", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dhExch", -1);

            break;

         /* pwdSymEnc */
         case 1:
            invokeStartElement (pctxt, "pwdSymEnc", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "pwdSymEnc", -1);

            break;

         /* pwdHash */
         case 2:
            invokeStartElement (pctxt, "pwdHash", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "pwdHash", -1);

            break;

         /* certSign */
         case 3:
            invokeStartElement (pctxt, "certSign", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "certSign", -1);

            break;

         /* ipsec */
         case 4:
            invokeStartElement (pctxt, "ipsec", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ipsec", -1);

            break;

         /* tls */
         case 5:
            invokeStartElement (pctxt, "tls", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "tls", -1);

            break;

         /* nonStandard */
         case 6:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H235NonStandardParameter);

            stat = asn1PD_H235NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 8;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* authenticationBES */
         case 8:
            invokeStartElement (pctxt, "authenticationBES", -1);

            pvalue->u.authenticationBES = ALLOC_ASN1ELEM (pctxt, H235AuthenticationBES);

            stat = asn1PD_H235AuthenticationBES (pctxt, pvalue->u.authenticationBES);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "authenticationBES", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DHset_halfkey                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235DHset_halfkey (OOCTXT* pctxt, H235DHset_halfkey* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 2048, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DHset_modSize                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235DHset_modSize (OOCTXT* pctxt, H235DHset_modSize* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 2048, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DHset_generator                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235DHset_generator (OOCTXT* pctxt, H235DHset_generator* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 2048, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DHset                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235DHset (OOCTXT* pctxt, H235DHset* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode halfkey */

   invokeStartElement (pctxt, "halfkey", -1);

   stat = asn1PD_H235DHset_halfkey (pctxt, &pvalue->halfkey);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "halfkey", -1);

   /* decode modSize */

   invokeStartElement (pctxt, "modSize", -1);

   stat = asn1PD_H235DHset_modSize (pctxt, &pvalue->modSize);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "modSize", -1);

   /* decode generator */

   invokeStartElement (pctxt, "generator", -1);

   stat = asn1PD_H235DHset_generator (pctxt, &pvalue->generator);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "generator", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TypedCertificate                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235TypedCertificate (OOCTXT* pctxt, H235TypedCertificate* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->type.numids, pvalue->type.subid);

   invokeEndElement (pctxt, "type", -1);

   /* decode certificate */

   invokeStartElement (pctxt, "certificate", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->certificate);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->certificate.numocts, pvalue->certificate.data);

   invokeEndElement (pctxt, "certificate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Identifier                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235Identifier (OOCTXT* pctxt, H235Identifier* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBMPString (pctxt, pvalue, 0);
   if (stat != ASN_OK) return stat;
   invokeCharStr16BitValue (pctxt, pvalue->nchars, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECpoint_x                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECpoint_x (OOCTXT* pctxt, H235ECpoint_x* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECpoint_y                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECpoint_y (OOCTXT* pctxt, H235ECpoint_y* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECpoint                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECpoint (OOCTXT* pctxt, H235ECpoint* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.xPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.yPresent = optbit;

   /* decode x */

   if (pvalue->m.xPresent) {
      invokeStartElement (pctxt, "x", -1);

      stat = asn1PD_H235ECpoint_x (pctxt, &pvalue->x);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "x", -1);
   }

   /* decode y */

   if (pvalue->m.yPresent) {
      invokeStartElement (pctxt, "y", -1);

      stat = asn1PD_H235ECpoint_y (pctxt, &pvalue->y);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "y", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdhp_modulus                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdhp_modulus (OOCTXT* pctxt, H235ECKASDH_eckasdhp_modulus* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdhp_weierstrassA                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdhp_weierstrassA (OOCTXT* pctxt, H235ECKASDH_eckasdhp_weierstrassA* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdhp_weierstrassB                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdhp_weierstrassB (OOCTXT* pctxt, H235ECKASDH_eckasdhp_weierstrassB* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdhp                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdhp (OOCTXT* pctxt, H235ECKASDH_eckasdhp* pvalue)
{
   int stat = ASN_OK;

   /* decode public_key */

   invokeStartElement (pctxt, "public_key", -1);

   stat = asn1PD_H235ECpoint (pctxt, &pvalue->public_key);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "public_key", -1);

   /* decode modulus */

   invokeStartElement (pctxt, "modulus", -1);

   stat = asn1PD_H235ECKASDH_eckasdhp_modulus (pctxt, &pvalue->modulus);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "modulus", -1);

   /* decode base */

   invokeStartElement (pctxt, "base", -1);

   stat = asn1PD_H235ECpoint (pctxt, &pvalue->base);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "base", -1);

   /* decode weierstrassA */

   invokeStartElement (pctxt, "weierstrassA", -1);

   stat = asn1PD_H235ECKASDH_eckasdhp_weierstrassA (pctxt, &pvalue->weierstrassA);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "weierstrassA", -1);

   /* decode weierstrassB */

   invokeStartElement (pctxt, "weierstrassB", -1);

   stat = asn1PD_H235ECKASDH_eckasdhp_weierstrassB (pctxt, &pvalue->weierstrassB);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "weierstrassB", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdh2_fieldSize                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdh2_fieldSize (OOCTXT* pctxt, H235ECKASDH_eckasdh2_fieldSize* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdh2_weierstrassA                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdh2_weierstrassA (OOCTXT* pctxt, H235ECKASDH_eckasdh2_weierstrassA* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdh2_weierstrassB                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdh2_weierstrassB (OOCTXT* pctxt, H235ECKASDH_eckasdh2_weierstrassB* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 0, 511, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH_eckasdh2                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH_eckasdh2 (OOCTXT* pctxt, H235ECKASDH_eckasdh2* pvalue)
{
   int stat = ASN_OK;

   /* decode public_key */

   invokeStartElement (pctxt, "public_key", -1);

   stat = asn1PD_H235ECpoint (pctxt, &pvalue->public_key);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "public_key", -1);

   /* decode fieldSize */

   invokeStartElement (pctxt, "fieldSize", -1);

   stat = asn1PD_H235ECKASDH_eckasdh2_fieldSize (pctxt, &pvalue->fieldSize);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "fieldSize", -1);

   /* decode base */

   invokeStartElement (pctxt, "base", -1);

   stat = asn1PD_H235ECpoint (pctxt, &pvalue->base);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "base", -1);

   /* decode weierstrassA */

   invokeStartElement (pctxt, "weierstrassA", -1);

   stat = asn1PD_H235ECKASDH_eckasdh2_weierstrassA (pctxt, &pvalue->weierstrassA);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "weierstrassA", -1);

   /* decode weierstrassB */

   invokeStartElement (pctxt, "weierstrassB", -1);

   stat = asn1PD_H235ECKASDH_eckasdh2_weierstrassB (pctxt, &pvalue->weierstrassB);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "weierstrassB", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ECKASDH                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ECKASDH (OOCTXT* pctxt, H235ECKASDH* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* eckasdhp */
         case 0:
            invokeStartElement (pctxt, "eckasdhp", -1);

            pvalue->u.eckasdhp = ALLOC_ASN1ELEM (pctxt, H235ECKASDH_eckasdhp);

            stat = asn1PD_H235ECKASDH_eckasdhp (pctxt, pvalue->u.eckasdhp);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "eckasdhp", -1);

            break;

         /* eckasdh2 */
         case 1:
            invokeStartElement (pctxt, "eckasdh2", -1);

            pvalue->u.eckasdh2 = ALLOC_ASN1ELEM (pctxt, H235ECKASDH_eckasdh2);

            stat = asn1PD_H235ECKASDH_eckasdh2 (pctxt, pvalue->u.eckasdh2);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "eckasdh2", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ClearToken                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ClearToken (OOCTXT* pctxt, H235ClearToken* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.timeStampPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.passwordPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.dhkeyPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.challengePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.randomPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.certificatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.generalIDPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   /* decode tokenOID */

   invokeStartElement (pctxt, "tokenOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->tokenOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->tokenOID.numids, pvalue->tokenOID.subid);

   invokeEndElement (pctxt, "tokenOID", -1);

   /* decode timeStamp */

   if (pvalue->m.timeStampPresent) {
      invokeStartElement (pctxt, "timeStamp", -1);

      stat = asn1PD_H235TimeStamp (pctxt, &pvalue->timeStamp);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "timeStamp", -1);
   }

   /* decode password */

   if (pvalue->m.passwordPresent) {
      invokeStartElement (pctxt, "password", -1);

      stat = asn1PD_H235Password (pctxt, &pvalue->password);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "password", -1);
   }

   /* decode dhkey */

   if (pvalue->m.dhkeyPresent) {
      invokeStartElement (pctxt, "dhkey", -1);

      stat = asn1PD_H235DHset (pctxt, &pvalue->dhkey);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "dhkey", -1);
   }

   /* decode challenge */

   if (pvalue->m.challengePresent) {
      invokeStartElement (pctxt, "challenge", -1);

      stat = asn1PD_H235ChallengeString (pctxt, &pvalue->challenge);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "challenge", -1);
   }

   /* decode random */

   if (pvalue->m.randomPresent) {
      invokeStartElement (pctxt, "random", -1);

      stat = asn1PD_H235RandomVal (pctxt, &pvalue->random);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "random", -1);
   }

   /* decode certificate */

   if (pvalue->m.certificatePresent) {
      invokeStartElement (pctxt, "certificate", -1);

      stat = asn1PD_H235TypedCertificate (pctxt, &pvalue->certificate);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "certificate", -1);
   }

   /* decode generalID */

   if (pvalue->m.generalIDPresent) {
      invokeStartElement (pctxt, "generalID", -1);

      stat = asn1PD_H235Identifier (pctxt, &pvalue->generalID);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "generalID", -1);
   }

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H235NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.eckasdhkeyPresent = 1;

                     invokeStartElement (pctxt, "eckasdhkey", -1);

                     stat = asn1PD_H235ECKASDH (pctxt, &pvalue->eckasdhkey);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "eckasdhkey", -1);
                     break;

                  case 1:
                     pvalue->m.sendersIDPresent = 1;

                     invokeStartElement (pctxt, "sendersID", -1);

                     stat = asn1PD_H235Identifier (pctxt, &pvalue->sendersID);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "sendersID", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IV8                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235IV8 (OOCTXT* pctxt, H235IV8* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 8, 8, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IV16                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235IV16 (OOCTXT* pctxt, H235IV16* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Params                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235Params (OOCTXT* pctxt, H235Params* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.ranIntPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.iv8Present = optbit;

   /* decode ranInt */

   if (pvalue->m.ranIntPresent) {
      invokeStartElement (pctxt, "ranInt", -1);

      stat = decodeUnconsInteger (pctxt, &pvalue->ranInt);
      if (stat != ASN_OK) return stat;
      invokeIntValue (pctxt, pvalue->ranInt);

      invokeEndElement (pctxt, "ranInt", -1);
   }

   /* decode iv8 */

   if (pvalue->m.iv8Present) {
      invokeStartElement (pctxt, "iv8", -1);

      stat = asn1PD_H235IV8 (pctxt, &pvalue->iv8);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "iv8", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.iv16Present = 1;

                     invokeStartElement (pctxt, "iv16", -1);

                     stat = asn1PD_H235IV16 (pctxt, &pvalue->iv16);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "iv16", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ENCRYPTED                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235ENCRYPTED (OOCTXT* pctxt, H235ENCRYPTED* pvalue)
{
   int stat = ASN_OK;

   /* decode algorithmOID */

   invokeStartElement (pctxt, "algorithmOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->algorithmOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->algorithmOID.numids, pvalue->algorithmOID.subid);

   invokeEndElement (pctxt, "algorithmOID", -1);

   /* decode paramS */

   invokeStartElement (pctxt, "paramS", -1);

   stat = asn1PD_H235Params (pctxt, &pvalue->paramS);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "paramS", -1);

   /* decode encryptedData */

   invokeStartElement (pctxt, "encryptedData", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->encryptedData);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->encryptedData.numocts, pvalue->encryptedData.data);

   invokeEndElement (pctxt, "encryptedData", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoToken_cryptoEncryptedToken                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235CryptoToken_cryptoEncryptedToken (OOCTXT* pctxt, H235CryptoToken_cryptoEncryptedToken* pvalue)
{
   int stat = ASN_OK;

   /* decode tokenOID */

   invokeStartElement (pctxt, "tokenOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->tokenOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->tokenOID.numids, pvalue->tokenOID.subid);

   invokeEndElement (pctxt, "tokenOID", -1);

   /* decode token */

   invokeStartElement (pctxt, "token", -1);

   stat = asn1PD_H235ENCRYPTED (pctxt, &pvalue->token);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "token", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncodedGeneralToken                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235EncodedGeneralToken (OOCTXT* pctxt, H235EncodedGeneralToken* pvalue)
{
   int stat = ASN_OK;

   stat = decodeOpenType (pctxt, &pvalue->data, &pvalue->numocts);
   if (stat != ASN_OK) return stat;
   invokeOpenTypeValue
      (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoToken_cryptoSignedToken_token                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235CryptoToken_cryptoSignedToken_token (OOCTXT* pctxt, H235CryptoToken_cryptoSignedToken_token* pvalue)
{
   int stat = ASN_OK;

   /* decode toBeSigned */

   invokeStartElement (pctxt, "toBeSigned", -1);

   stat = asn1PD_H235EncodedGeneralToken (pctxt, &pvalue->toBeSigned);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "toBeSigned", -1);

   /* decode algorithmOID */

   invokeStartElement (pctxt, "algorithmOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->algorithmOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->algorithmOID.numids, pvalue->algorithmOID.subid);

   invokeEndElement (pctxt, "algorithmOID", -1);

   /* decode paramS */

   invokeStartElement (pctxt, "paramS", -1);

   stat = asn1PD_H235Params (pctxt, &pvalue->paramS);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "paramS", -1);

   /* decode signature */

   invokeStartElement (pctxt, "signature", -1);

   stat = decodeDynBitString (pctxt, (ASN1DynBitStr*)&pvalue->signature);
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->signature.numbits, pvalue->signature.data);

   invokeEndElement (pctxt, "signature", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoToken_cryptoSignedToken                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235CryptoToken_cryptoSignedToken (OOCTXT* pctxt, H235CryptoToken_cryptoSignedToken* pvalue)
{
   int stat = ASN_OK;

   /* decode tokenOID */

   invokeStartElement (pctxt, "tokenOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->tokenOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->tokenOID.numids, pvalue->tokenOID.subid);

   invokeEndElement (pctxt, "tokenOID", -1);

   /* decode token */

   invokeStartElement (pctxt, "token", -1);

   stat = asn1PD_H235CryptoToken_cryptoSignedToken_token (pctxt, &pvalue->token);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "token", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HASHED                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235HASHED (OOCTXT* pctxt, H235HASHED* pvalue)
{
   int stat = ASN_OK;

   /* decode algorithmOID */

   invokeStartElement (pctxt, "algorithmOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->algorithmOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->algorithmOID.numids, pvalue->algorithmOID.subid);

   invokeEndElement (pctxt, "algorithmOID", -1);

   /* decode paramS */

   invokeStartElement (pctxt, "paramS", -1);

   stat = asn1PD_H235Params (pctxt, &pvalue->paramS);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "paramS", -1);

   /* decode hash */

   invokeStartElement (pctxt, "hash", -1);

   stat = decodeDynBitString (pctxt, (ASN1DynBitStr*)&pvalue->hash);
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->hash.numbits, pvalue->hash.data);

   invokeEndElement (pctxt, "hash", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoToken_cryptoHashedToken                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235CryptoToken_cryptoHashedToken (OOCTXT* pctxt, H235CryptoToken_cryptoHashedToken* pvalue)
{
   int stat = ASN_OK;

   /* decode tokenOID */

   invokeStartElement (pctxt, "tokenOID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->tokenOID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->tokenOID.numids, pvalue->tokenOID.subid);

   invokeEndElement (pctxt, "tokenOID", -1);

   /* decode hashedVals */

   invokeStartElement (pctxt, "hashedVals", -1);

   stat = asn1PD_H235ClearToken (pctxt, &pvalue->hashedVals);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "hashedVals", -1);

   /* decode token */

   invokeStartElement (pctxt, "token", -1);

   stat = asn1PD_H235HASHED (pctxt, &pvalue->token);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "token", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CryptoToken                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H235CryptoToken (OOCTXT* pctxt, H235CryptoToken* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* cryptoEncryptedToken */
         case 0:
            invokeStartElement (pctxt, "cryptoEncryptedToken", -1);

            pvalue->u.cryptoEncryptedToken = ALLOC_ASN1ELEM (pctxt, H235CryptoToken_cryptoEncryptedToken);

            stat = asn1PD_H235CryptoToken_cryptoEncryptedToken (pctxt, pvalue->u.cryptoEncryptedToken);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "cryptoEncryptedToken", -1);

            break;

         /* cryptoSignedToken */
         case 1:
            invokeStartElement (pctxt, "cryptoSignedToken", -1);

            pvalue->u.cryptoSignedToken = ALLOC_ASN1ELEM (pctxt, H235CryptoToken_cryptoSignedToken);

            stat = asn1PD_H235CryptoToken_cryptoSignedToken (pctxt, pvalue->u.cryptoSignedToken);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "cryptoSignedToken", -1);

            break;

         /* cryptoHashedToken */
         case 2:
            invokeStartElement (pctxt, "cryptoHashedToken", -1);

            pvalue->u.cryptoHashedToken = ALLOC_ASN1ELEM (pctxt, H235CryptoToken_cryptoHashedToken);

            stat = asn1PD_H235CryptoToken_cryptoHashedToken (pctxt, pvalue->u.cryptoHashedToken);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "cryptoHashedToken", -1);

            break;

         /* cryptoPwdEncr */
         case 3:
            invokeStartElement (pctxt, "cryptoPwdEncr", -1);

            pvalue->u.cryptoPwdEncr = ALLOC_ASN1ELEM (pctxt, H235ENCRYPTED);

            stat = asn1PD_H235ENCRYPTED (pctxt, pvalue->u.cryptoPwdEncr);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "cryptoPwdEncr", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

