/** \file src/views.hh */
/*
 * This file is part of assoGiate,
 * an editor of the file types database for GNOME.
 *
 * Copyright (C) 2007 Kevin Daughtridge <kevin@kdau.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ASSOGIATE__VIEWS_HH
#define ASSOGIATE__VIEWS_HH

#include "misc.hh"

#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>

/******************************************************************************/
namespace assoGiate {
/******************************************************************************/

/******************************************************************************/
class CategoriesColumns : public Gtk::TreeModelColumnRecord {
/******************************************************************************/

public:

	enum Filter {
		SEPARATOR,
		SINGLE,
		ALL,
		OVERRIDE,
		SEARCH
	};

	static CategoriesColumns& get();

	Gtk::TreeModelColumn<Filter> filter;
	Gtk::TreeModelColumn<ustring> id;
	Gtk::TreeModelColumn<RefPtr<Gdk::Pixbuf> > icon;
	Gtk::TreeModelColumn<ustring> name;

private:

	CategoriesColumns();

}; /* class CategoriesColumns */

/******************************************************************************/
class CategoriesStore : public Gtk::ListStore {
/******************************************************************************/

public:

	static RefPtr<CategoriesStore> get_filter();
	static RefPtr<CategoriesStore> get_selector();
	
	static Gtk::TreeIter get_filter_item(CategoriesColumns::Filter item);
	
	static bool row_separator_func(const RefPtr<Gtk::TreeModel>&,
		const Gtk::TreeIter& iter);

	CategoriesColumns &m_cols;

protected:

	explicit CategoriesStore(bool filter);

	iterator append(const ustring& id, const ustring& icon,
		const ustring& name);
	iterator append(CategoriesColumns::Filter filter, const ustring& icon,
		const ustring& name);

	bool m_is_filter;

}; /* class CategoriesStore */

/******************************************************************************/
class TypesColumns : public Gtk::TreeModelColumnRecord {
/******************************************************************************/

public:
	
	static TypesColumns& get();

	Gtk::TreeModelColumn<MimeType*> obj;
	Gtk::TreeModelColumn<bool> alias;
	Gtk::TreeModelColumn<Pango::Style> style;
	Gtk::TreeModelColumn<ustring> category, name, description;

private:

	TypesColumns();

}; /* class TypesColumns */

/******************************************************************************/
class TypesStore : public Gtk::ListStore {
/******************************************************************************/

public:

	static RefPtr<TypesStore> create(const RefPtr<MimeDatabase>& database);
	
	void show_category(const ustring& category);
	void show_all();
	void show_override();
	void show_results(const ustring& query);

private:

	TypesStore(const RefPtr<MimeDatabase>& database);
	
	void reload();
	void load_type(MimeType& type, bool alias, const ustring& category,
		const ustring& name, const ustring& description);

	int default_compare(const Gtk::TreeIter& lhs, const Gtk::TreeIter& rhs)
		const;

	TypesColumns &m_cols;
	RefPtr<MimeDatabase> m_database;
	
	CategoriesColumns::Filter m_filter;
	ustring m_param;

}; /* class TypesStore */

/******************************************************************************/
class TypesView : public Gtk::TreeView {
/******************************************************************************/

public:

	TypesView();
	
	sigc::signal<void, guint32> signal_right_click();

protected:

	virtual bool on_button_press_event(GdkEventButton* e);

private:

	bool on_search_equal(const RefPtr<Gtk::TreeModel>&, int, const ustring& key,
		const Gtk::TreeIter& iter) const;

	TypesColumns &m_cols;

	sigc::signal<void, guint32> s_right_click;

}; /* class TypesView */

/******************************************************************************/
class MagicTypesColumns : public Gtk::TreeModelColumnRecord {
/******************************************************************************/

public:

	static MagicTypesColumns& get();

	Gtk::TreeModelColumn<MagicMatch::Type> type;
	Gtk::TreeModelColumn<ustring> name;

private:

	MagicTypesColumns();

}; /* class MagicTypesColumns */

/******************************************************************************/
class MagicTypesStore : public Gtk::ListStore {
/******************************************************************************/

public:

	static RefPtr<MagicTypesStore> get();

	MagicTypesColumns &m_cols;

private:

	MagicTypesStore();
	
	iterator append(MagicMatch::Type type, const ustring& name);

}; /* class MagicTypesStore */

} /* namespace assoGiate */

#endif /* ASSOGIATE__MISC_HH */
