#include <iomanip>
#include <iostream>
#include "expr_names.h"
 
using std::cout;
using std::endl;

void ExprNames::add (char* name)
 {
   if (name)
    {
      _used = true;
      _names[_curr] = name;
    }
   else
    {
      _names[_curr] = (char*)"-1";
    }
   _curr++;
 }

void ExprNames::print (char* table_name)
 {
   if (!_used) return;

   cout << "static int " << table_name << "ExprMap[] =" << endl << " {" << endl;
   for (int i = 0; i < _curr; i++)
    {
      cout << "   " << _names[i];
      if (i < _curr - 1)
	 cout << ",";
      cout << endl;
    }
   cout << " };" << endl << endl;
 }
