// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Naming_h__
#define __Naming_h__

#include <iostream>
#include <string>
using namespace std;
// This class encapsulates the naming scheme for generated functions etc.

#ifdef ACMODEL
class ACM_Call;
class ACM_Execution;
class ACM_Aspect;
class ACM_Any;
#else
class JPL_MethodCall;
class JPL_Method;
class JPL_Aspect;
class JoinPointLoc;
#endif
class AdviceInfo;
class AspectInfo;

namespace Puma {
  class CObjectInfo;
  class CFunctionInfo;
  class CStructure;
  class CRecord;
  class CScopeInfo;
  class FileUnit;
} // namespace Puma

using namespace Puma;

class Naming {
  static bool unary (CFunctionInfo *func);
  static void scope_name (ostream &out, CScopeInfo *scope);
  
public:
  static void op_name (ostream &out, CFunctionInfo *func);
  static void conv_name (ostream &out, CFunctionInfo *func);
  static void constr_name (ostream &out, CFunctionInfo *func);
  static void destr_name (ostream &out, CFunctionInfo *func);
  static void mangle (ostream &out, CObjectInfo *obj);
#ifdef ACMODEL
  static void call_wrapper (ostream& out, ACM_Call *jpl, unsigned depth);
  static void exec_inner (ostream& out, ACM_Any *jpl);
  static void action_wrapper (ostream& out, ACM_Any *loc, unsigned depth);
  static void exec_advice (ostream& out, ACM_Execution *jpl, AdviceInfo *ad);
  static void call_advice (ostream& out, ACM_Call *jpl, AdviceInfo *ad);
  static void call_func (ostream& out, CStructure *in, AdviceInfo *ad);
//  static void aspectof(ostream& out, ACM_Any *loc, AspectInfo *aspect);
  static void local_id (ostream& out, ACM_Any *jpl);
  static void tjp_struct(ostream& out, ACM_Any *loc, int depth);
  static void tjp_instance(ostream& out, ACM_Any *loc);
  static void tjp_args_array(ostream& out, ACM_Any *loc);
  static void tjp_argtypes(ostream& out, ACM_Any *loc);
  static void cflow (ostream& out, ACM_Aspect &jpl_aspect, int index);
#else
  static void call_wrapper (ostream& out, JPL_MethodCall *jpl, unsigned depth);
  static void exec_inner (ostream& out, JoinPointLoc *jpl);
  static void action_wrapper (ostream& out, JoinPointLoc *loc, unsigned depth);
  static void exec_advice (ostream& out, JPL_Method *jpl, AdviceInfo *ad);
  static void call_advice (ostream& out, JPL_MethodCall *jpl, AdviceInfo *ad);
  static void call_func (ostream& out, CStructure *in, AdviceInfo *ad);
//  static void aspectof(ostream& out, JoinPointLoc *loc, AspectInfo *aspect);
  static void local_id (ostream& out, JoinPointLoc *jpl);
  static void tjp_struct(ostream& out, JoinPointLoc *loc, int depth);
  static void tjp_instance(ostream& out, JoinPointLoc *loc);
  static void tjp_args_array(ostream& out, JoinPointLoc *loc);
  static void tjp_argtypes(ostream& out, JoinPointLoc *loc);
  static void cflow (ostream& out, JPL_Aspect &jpl_aspect, int index);
#endif
  static void tjp_typedef (ostream& out, const char *name);
  static void type_check_function (ostream &out, CRecord *in, CRecord *cfor);
  static void type_check_func (ostream &out, CRecord *in, const string &name);
  static void guard (ostream &out, FileUnit *unit);
  static void mangle_file (ostream &out, FileUnit *unit);
  static void mangle_file (ostream &out, const char *name);
  
  // checks
  static bool is_tjp_object (const char *candidate);
};

#endif // __Naming_h__
