# ifndef __AUTOMATON__
# define __AUTOMATON__

# include "classes.h"

class ListData
 {
   public:
      virtual ~ListData () {};
      virtual void Print (void) = 0;
 };
      
class ListEntry
 {    ListEntry* Next;
      ListEntry* Prev;
      ListData*  Data;
   public:
      ListEntry (ListData* New);
      void Insert (ListEntry *Behind, ListEntry* Before);
      void Remove (void);
      ListEntry* NextEntry (void);
      ListEntry* PrevEntry (void);
      ListData* GetData (void);
 };

class List : public ListData
 { protected:
      ListEntry* First;
      ListEntry* Last;
      long       Entries;
   public:
      List (void);
      virtual ~List (void);
      int Empty (void);
      long Length (void);
      void Append (ListData* New);
      void Remove (ListData* ToRemove);
      void StartScanning (ListEntry*& Context);
      ListData* GetNext (ListEntry*& Context);
      void ShiftEntries (List& List);
      void CopyEntries (List& ToCopy);
      int IsIn (ListData* ToFind);
      int IsEqual (List& List);
      virtual void Print (void);
 };

class Stack : public List
 {
   public:
      void PushList (List& List);
      void Push (ListData* New);
      ListData* Pop (void);
 };

typedef enum { EPSILON_TRANS, CHAR_CLASS_TRANS, CLASS_NAME_TRANS,
	       CHAR_TRANS
	     } TransitionType;

class State;

class Transition : public ListData
 { 
   public:
      State*         TransitionState;
      TransitionType Type;
      ClassId        Id;
      union
       { char*   Name;
	 char    Char;
       } Temp;
      Transition (TransitionType Type, State* State);
      Transition (TransitionType Type, char Char, State* State);
      Transition (TransitionType Type, char* Name, State* State);
      Transition (TransitionType Type, ClassId Id, State* State);
      void Print (void);
 };


typedef enum { NORMAL_STATE, END_STATE , LOOK_AHEAD_END_STATE } StateType;

class State : public ListData
 { 
   int       Expression;
   public:
   StateType Type;
   int       LookAhead;
   List      EpsilonTransitions;
   List      NonEpsilonTransitions;
   int       Group;
   int       Number;
   State*    Representative;
   State (void);
   ~State (void);
   int Expr ();
   void Expr (int);
   void AddTransition (TransitionType Type, State* State);
   void AddTransition (TransitionType Type, char Char, State* State);
   void AddTransition (TransitionType Type, char* Name, State* State);
   void AddTransition (TransitionType Type, ClassId Id, State* State);
   void ShiftTransitionList (State* State);
   void Print (void);
 };

class Automaton
 {
   List States;
 public:
   State* Start;
   State* End;
   Automaton (void);
   ~Automaton (void);
   void ShiftStates (Automaton& Automaton);
   State* AddState (void);
   void RemoveState (State* State);
   void ShiftState (Automaton& From, State* State);
   void ScanStates (ListEntry*& Context);
   State* NextState (ListEntry*& Context);
   void Print (void);
 };

class DFAStateDescriptor : public ListData
 { public:
      List NFAStates;
      State* DFAState;
      void Print (void);
 };


# endif



