------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--               M E T R I C S . A S I S _ U T I L I T I E S                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                   Copyright (C) 2002-2004, ACT Europe                    --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by ACT Europe                         --
-- (http://www.act-europe.fr).                                              --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines different ASIS secondary queries needed in metrics
--  tools

with Asis;                       use Asis;
with Asis.Extensions.Flat_Kinds; use Asis.Extensions.Flat_Kinds;

with METRICS.Metric_Definitions; use METRICS.Metric_Definitions;

package METRICS.ASIS_Utilities is

   function Is_Executable_Body (El : Element) return Boolean;
   --  Checks if its argument represents the executable body, that is, the
   --  body for which it makes sense to compute the complexity metrics. At
   --  the moment, we compute complexity for subprogram, task and entry bodies.
   --  We do not compute the complexity for protected bodies (they just do not
   --  contain statements on their own). For a package body this function
   --  returns true only if the body contains statements of its own.

   function Is_Program_Unit (El : Element) return Boolean;
   --  Checks if its argument represents a program unit for which it makes
   --  makes sense to compute some metrics. See the body for the details.
   --  Note, that renamings, instantiations and (generic) subprogram
   --  declarations are considered as program units only if they are library
   --  items.

   function Is_RM_Program_Unit (El : Element) return Boolean;
   --  Checks if the argument corresponds to the notion of a program unit as
   --  it is defioned in RM95 10.1(1) ("A program unit is either a package,
   --  a task unit, a protected unit, a protected entry, a generic unit, or
   --  an explicitly declared subprogram other than an enumeration literal.")

   function May_Contain_Program_Units
     (El_Kind : Flat_Element_Kinds)
      return    Boolean;
   --  Checks if the element of the given kind may contain program units as its
   --  components.

   function Adds_New_Nesting_Level
     (El_Kind : Flat_Element_Kinds)
      return    Boolean;
   --  Checks if the element of the given kind adds a new level pf construct
   --  nesting, according to the GNAT -gnatyLnnn option.

   function Statement_Complexity (Stmt : Element) return Metric_Count;
   --  Computes the complexity added by the argument statement to the McCabe
   --  cyclomatic complexity. See the body of
   --  METRICS.Compute.Compute_Complexity for the description of the complexity
   --  value added by different statements. If the argument is not a statement,
   --  returns 0.

   function Control_Form_Complexity (Expr : Element) return Metric_Count;
   --  Computes the complexity added by the argument short-circuit control
   --  form.  See the body of METRICS.Compute.Compute_Complexity for the
   --  description of the complexity value added by short-circuits. If the
   --  argument is not a statement, returns 0.

   function Is_Static_Loop (Loop_Stmt : Element) return Boolean;
   --  Checks if its argument is a static for-loop (that is, the discrete
   --  subtype indication in the loop parameter specification is static).
   --  Returns False for any unexpected element

   function Is_Non_Structural_Statement
     (Stmt         : Element;
      Exit_Is_Goto : Boolean := True)
      return         Boolean;
   --  Check if this statement argument is a non-structural control statement.
   --  If Stmt is not a control statement (see the list of expected statement
   --  kinds), the result is always False.
   --
   --  A control statement is considered as non-structural, if it contains some
   --  statement which transfers the control outside this control statement,
   --  and this does not allow to treat this control statement as one-entry and
   --  one-exit control structure.
   --
   --  The following ways of transferring the control are possible:
   --  - goto statement (if it transfers the control outside the control
   --    statement in question)
   --  - return statement
   --  - raise statement
   --  - terminate alternative in a selective accept
   --  - exit statement is considered as (non-structural) control transfer if
   --    Exit_Is_Goto is set ON)
   --
   --  Different forms of a select statement are considered as non-structural
   --  only if they contain any of the transfer control statements listed above
   --  (that is, asynchronous select is not considered as non-structural
   --  statement on its own)
   --
   --  Expected statement kinds:
   --    An_If_Statement
   --    A_Case_Statement
   --    A_Loop_Statement
   --    A_While_Loop_Statement
   --    A_For_Loop_Statement
   --    A_Selective_Accept_Statement
   --    A_Timed_Entry_Call_Statement
   --    A_Conditional_Entry_Call_Statement
   --    An_Asynchronous_Select_Statement

   function CU_Profile (CU : Compilation_Unit) return String;
   --  Return the general "profile" of the argument unit which integrates the
   --  general unit attributes (such as unit kind, class etc.) and which
   --  ends with the unit name (e.g. "private generic package body Foo"

end METRICS.ASIS_Utilities;
