/* :: ascii-jump project
   :: $Id: scrcup.c,v 1.1.1.1 2003/02/28 10:05:04 loth Exp $
   
   :: copyright (c) 2003 grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define SCRCUP_C
#include "scrcup.h"

static struct widget* scr_cup, *win_cup, *menu_cup;
static struct widget* win_hill, *menu_hill;
static struct widget* win_cup, *menu_cup;
static struct widget *win_jumper, *menu_jumper;
static struct widget *win_select, *line_name, *menu_control, *menu_color, *menu_level;

static struct object *current_jumper;

static struct object *jumpers_rewind(int n)
{
	struct object *j = jumpers;
	while (n-- > 0)
		SWITCH(j);
	return j;
}

void scrcup_show(void)
{
	scr_cup->current = win_cup;
	screen_hideall(scr_cup);
	status = MENU;
	screen = scr_cup;
}

static void wincup_show()
{
	scr_cup->current = win_cup;
	screen_hideall(scr_cup);
}

static void winhill_show()
{
	scr_cup->current = win_hill;
	win_hill->hidden = 0;
	screen_hideall(scr_cup);
}

static void winjumper_show()
{
	scr_cup->current = win_jumper;
	win_jumper->hidden = 0;
	screen_hideall(scr_cup);
}

static void winjumper_refresh()
{
	inputline_fill(menu_jumper->current, current_jumper->name);
	menu_tick(menu_jumper->current);
	winjumper_show();
}

static void winselect_show(void)
{
	win_select->hidden = 0;
	scr_cup->current = win_select;
	screen_hideall(scr_cup);
}

static void winselect_refresh()
{
	
	screen_hideall(scr_cup);
	current_jumper = jumpers_rewind(menu_selected_number(menu_jumper));
	inputline_fill(line_name, current_jumper->name);
	menu_select(menu_color, current_jumper->color-2);	
	menu_select(menu_control, current_jumper->level);
	menu_level->hidden = 1;
	menu_color->hidden = 1;
	if (current_jumper->level) {
		menu_select(menu_level, current_jumper->level-1);	
		menu_level->hidden = 0;
	} else 
		menu_color->hidden = 0;
		
	win_select->current = line_name;
	winselect_show();
}

static void set_color()
{
	current_jumper->color = menu_selected_number(menu_color) + 2;
	list_switch(win_select, NEXT_WIDGET);
}

static void set_control()
{
	current_jumper->level = menu_selected_number(menu_control);
	menu_level->hidden = 1;
	menu_color->hidden = 1;
	if (current_jumper->level) 
		menu_level->hidden = 0;
	else {
		menu_color->hidden = 0;
		sl_cls();
	}
	list_switch(win_select, NEXT_WIDGET);
}

static void set_name()
{
	xfree(current_jumper->name);
	current_jumper->name = strdup(inputline_caption(line_name));
}

static void set_level()
{
	current_jumper->level += menu_selected_number(menu_level);
	list_switch(win_select, NEXT_WIDGET);
}

static char *colors[] = {
"grey",
"white",
"green",
"light green",
"cyan",
"light red",
"light cyan",
"light blue",
NULL
};

static void winselect_create()
{
	int i = 0;
	int uw = sl_screen_width/10;
	win_select = window_add(scr_cup, "setup", uw*2, 2, uw*6+3, 20);
		
	label_add(win_select, 1, 2, 10, "name:: ");
	line_name = inputline_add(win_select, 11, 2, uw*6, set_name);

	menu_control = menu_add(win_select, 1, 4, uw*6, 2, 0);
	menuobj_add(menu_control, "human",'h', set_control, 0);
	menuobj_add(menu_control, "cpu", 'u',set_control, 0);
	
	menu_color = menu_add(win_select, 1, 7, uw*6, 6, 0);
	for (; colors[i]; i++)
		menuobj_add(menu_color, colors[i],
			colors[i][d(strlen(colors[i]))-1], set_color, 0);		
	
	menu_level = menu_add(win_select, 1, 7, uw*6, 4, 0);
	menuobj_add(menu_level, "poor",'p', set_level, 0);
	menuobj_add(menu_level, "good", 'o',set_level, 0);
	menuobj_add(menu_level, "best", 'b',set_level, 0);

	menuobj_add(menu_add(win_select, 1, 18, uw*6, 1, 0), 
		"<<<",'<', winjumper_refresh, 0);
}
	
static void scrcup_startcup()
{
	int i;
	struct widget *mo = menu_jumper->kids;
	char *title;
	for (i = 0; i < njumpers; jumpers_tab[i++] = 0);
	for (i = 0; i < nhills; hills_tab[i++] = 0);
	for (i = 0; mo; SWITCH(mo)) {
		if ((mo = menu_ticked(mo))) {
			menu_jumper->current = mo;
			current_jumper = jumpers_rewind(menu_selected_number(menu_jumper));
			jumpers_tab[i++] = current_jumper;
		} else
			break;
	}
	for (mo = menu_hill->kids, i = 0; mo; SWITCH(mo)) {
		if ((mo = menu_ticked(mo))) {
			menu_hill->current = mo;
			title = menu_selected_caption(menu_hill);
			hills_tab[i++] = hill_find(hills, title);
		} else
			break;
	}
	if (jumpers_tab[0] && hills_tab[0])
		cup_refresh();
}

void scrcup_init(void)
{
	struct hill *h = hills;
	struct object *j = jumpers;
	int uw = sl_screen_width/10;
	int uh = sl_screen_height/10;
	scr_cup = screen_add();
	win_cup = window_add(scr_cup, "world cup", uw*3, uh*2, uw*4, 10);
	menu_cup = menu_add(win_cup, 1, 2, uw*4-2, 8, 0);

	winselect_create();
	
	menuobj_add(menu_cup, "select competitors", 'c', winjumper_show, 0);
	menuobj_add(menu_cup, "select hills", 'h',winhill_show, 0);
	menuobj_add(menu_cup, "start world cup", 't', 
		scrcup_startcup, OBJ_DOWN);
	menuobj_add(menu_cup, "<<<", '<', scrmain_show, OBJ_DOWN);

	win_jumper = window_add(scr_cup, 
		"_select _competitors", uw*2, 1, uw*6+3, njumpers+5);
	menu_jumper = menu_add(win_jumper, 1, 2, uw*6, njumpers+5, 1);
	for (; j; SWITCH(j))
		menuobj_add(menu_jumper, j->name, 
			j->name[0],  winselect_refresh, 0);
	menuobj_add(menu_jumper, "<<<", '<',
		wincup_show, OBJ_DOWN+OBJ_UNTICKABLE);
	
	win_hill = window_add(scr_cup, "se_lect hi_l_l",
		uw*2, 1, uw*6+3, uh*10-1);
	menu_hill = menu_add(win_hill, 1, 2, uw*6, uh*10-3, 1);
	for (; h; SWITCH(h))
		menuobj_add(menu_hill, h->name, 
			h->name[d(strlen(h->name))-1], 0, 0);
	menuobj_add(menu_hill, "<<<",'<',
		wincup_show, OBJ_DOWN+OBJ_UNTICKABLE);
}
