/* $Id: ArkNetwork.cpp,v 1.2 2002/04/15 22:21:00 zongo_fr Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkNetwork.h>

namespace Ark 
{

// FIXME: Beware the bit endianness !
WriteStream &NetWriteByte (WriteStream &stream, unsigned char byte)
{
    const char* mem = reinterpret_cast<const char*>(&byte);
    return stream.write(mem, sizeof(byte));
}

WriteStream &NetWriteShort (WriteStream &stream, short value)
{
    const char* mem = reinterpret_cast<const char*>(&value);
    return stream.write(mem, sizeof(value));
}

WriteStream &NetWriteInt (WriteStream &stream, int value)
{
    const char* mem = reinterpret_cast<const char*>(&value);
    return stream.write(mem, sizeof(value));
} 

WriteStream &NetWriteScalar (WriteStream &stream, scalar value)
{
    const char* mem = reinterpret_cast<const char*>(&value);
    return stream.write(mem, sizeof(value));
}

WriteStream &NetWriteString (WriteStream &stream,const String &value)
{
   stream.write(value.c_str(), value.length());
   return NetWriteByte(stream, 0);
}

ReadStream &NetReadByte (ReadStream &stream, unsigned char &byte)
{
    char* mem = reinterpret_cast<char*>(&byte);
    return stream.read(mem,sizeof(byte));
}

ReadStream &NetReadShort (ReadStream &stream, short &value)
{
    char* mem = reinterpret_cast<char*>(&value);
    return stream.read(mem,sizeof(value));
}

ReadStream &NetReadInt (ReadStream &stream, int &value)
{
    char* mem = reinterpret_cast<char*>(&value);
    return stream.read(mem,sizeof(value));
}

ReadStream &NetReadScalar (ReadStream &stream, scalar &value)
{
    char* mem = reinterpret_cast<char*>(&value);
    return stream.read(mem,sizeof(value));
}

ReadStream &NetReadString (ReadStream &stream, String &value)
{
   value = "";
   char c;
   while (stream.read(&c,1) && c != 0)
      value.push_back(c);

   return stream;
}

}

