/* $Id: ArkLoaderTEX.cpp,v 1.8 2001/10/27 20:22:26 zongo_fr Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"
#include <Ark/ArkImage.h>
#include <Ark/ArkLoader.h>
#include <Ark/ArkConfig.h>
#include <stdio.h>


namespace Ark
{

   class LoaderTEX : public Loader
   {
	 /// Returns true if the file pointed to by \c name does really
	 /// contains a TEX texture file definition.
	 virtual bool CanLoad (ObjectType type, Stream &file,
			       const String &name, const String &args)
	 {
	    if (type != V_IMAGE)
	       return false;
	    
	    String line;
	    std::getline (file, line);
	    if (line.find("Ark Texture Def", 0) != String::npos)
	       return true;
	    
	    return false;
	 }
	 
	 /// Load the file pointed to by \c name, and read a object in it.
	 /// It will update the progress every \c granularity percents.
	 virtual bool Load (Object *vis, Stream &file, const String &name, const String &args,
			    Cache *cache,
			    Progress *progress, int granularity)
	 {
	    if (vis == NULL || vis->Type() != V_IMAGE)
	       return false;
	    
	    Config cfg;
	    cfg.Load (name, file);
	    
	    String realname = cfg.GetStr ("Image", String());
	    if (realname.empty() || realname == name)
	       return false;
	    
	    // Try to load the file pointed to by realname
	    return Sys()->GetLoaders()->Load
	       (vis, realname, cache, progress, granularity);
	 }
	 
	 /// Returns informations about the formats supported by this loader.
	 virtual String GetInformations()
	 {
	    return "Ark Texture Definition";
	 }
   };
   
   void ark_AddTexLoader (Loaders *loaders)
   {
      // FIXME: is TEX useful ??
      //loaders->Add (new LoaderTEX());
   }
   
/* namespace Ark */
}
