/*
 * Argus Software.  Argus files - Input includes
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */

/*  ArgusSource.h */

#ifndef ArgusSource_h
#define ArgusSource_h

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <string.h>
#include <strings.h>
#include <pcap.h>
 
int pcap_read(pcap_t *, int cnt, pcap_handler, u_char *);
int pcap_offline_read(pcap_t *, int, pcap_handler, u_char *);

#include <signal.h>
#include <errno.h>

#include <extract.h>
#include <fddi.h>

#include <net/if.h>

#if defined(__NetBSD__)
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#if !defined(__OpenBSD__)
#include <netinet/if_ether.h>
#endif

#include <netinet/in.h>

#if !defined(__OpenBSD__) || (defined(__OpenBSD__) && !defined(_NETINET_IF_SYSTEM_H_))
#define _NETINET_IF_SYSTEM_H_
#include <netinet/in_systm.h>
#endif

#ifndef _NETINET_IP_H_
#include <netinet/ip.h>
#define _NETINET_IP_H_
#endif

#ifndef _NETINET_UDP_H_
#include <netinet/udp.h>
#define _NETINET_UDP_H_
#endif

#include <netinet/tcp.h>

 
#define ARGUSLIBPPKTFILE	1
#define ARGUSSNOOPKTFILE	2
#define ARGUSMOATTSHPKTFILE	3
 

#define ARGUS_MAXINTERFACE	5

struct ArgusDeviceStruct {
   struct ArgusListObjectStruct *nxt;
   char *name;
};

struct ArgusRfileStruct {
   struct ArgusListObjectStruct *nxt;
   char *name;
};

struct arguspcap_sf {
   FILE *rfile;
   int swapped;
   int hdrsize;
   int version_major;
   int version_minor;
   u_char *base;
};
  
struct arguspcap_md {
   struct pcap_stat stat;
   /*XXX*/
   int use_bpf;		/* using kernel filter */
   u_long	TotPkts;	/* can't oflow for 79 hrs on ether */
   u_long	TotAccepted;	/* count accepted by filter */
   u_long	TotDrops;	/* count of dropped packets */
   long	TotMissed;	/* missed by i/f during this run */
   long	OrigMissed;	/* missed by i/f before this run */
#ifdef linux
   int	sock_packet;	/* using Linux 2.0 compatible interface */
   int	timeout;	/* timeout specified to pcap_open_live */
   int	clear_promisc;	/* must clear promiscuous mode when we close */
   int	cooked;		/* using SOCK_DGRAM rather than SOCK_RAW */
   int	lo_ifindex;	/* interface index of the loopback device */
   char 	*device;	/* device name */
   struct pcap *next;	/* list of open promiscuous sock_packet pcaps */
#endif
};
  
struct arguspcap {
   int fd;
   int snapshot;
   int linktype;
   int tzoff;		/* timezone offset */
   int offset;		/* offset for proper alignment */
 
   struct arguspcap_sf sf;
   struct arguspcap_md md;
  
   /*
    * Read buffer.
    */
   int bufsize;
   u_char *buffer;
   u_char *bp;
   int cc;
  
   /*
    * Place holder for pcap_next().
    */
   u_char *pkt;
 
   /*
    * Placeholder for filter code if bpf not in kernel.
    */
   struct bpf_program fcode;
  
   char errbuf[PCAP_ERRBUF_SIZE];
};

#define MAXSTRSIZE 1024
#define ARGUS_MAXSNAPLEN 65535
 
struct ArgusInterfaceStruct {
   struct ArgusDeviceStruct *ArgusDevice;
   struct ifreq ifr;
   pcap_t *ArgusPd;
   struct bpf_program ArgusFilter;
   int state, index, ArgusInterfaceType;
   pcap_handler ArgusCallBack;

   struct arguspcap ArgusPcap;
  
   unsigned int ArgusLocalNet, ArgusNetMask;
   struct pcap_stat ArgusStat;

   long long ArgusTotalPkts;
   long long ArgusTotalIPPkts;
   long long ArgusTotalNonIPPkts;
   long long ArgusLastPkts;
   long long ArgusTotalDrop;
   long long ArgusLastDrop;
   long long ArgusTotalBytes;
   long long ArgusLastBytes;

   u_char *ArgusPacketBuffer;
   u_char ArgusPacketBufferBuffer[ARGUS_MAXSNAPLEN];
};


struct ArgusMoatTshPktHdr {
   unsigned int sec;
   char interface;
   char usec[3];
   struct ip ip;
   struct tcphdr tcp;
};

#define SNOOP_FILE_OFFSET 16

struct ArgusSnoopPktHdr {
    unsigned int len;
    unsigned int tlen;
    unsigned int pad[2];
    struct timeval argtvp;
};


#define ARGUS_HOLDING	1

struct ArgusSourceStruct {
   int state;
 
   struct ArgusListStruct *ArgusDeviceList;
   struct ArgusListStruct *ArgusRfileList;
   struct ArgusModelerStruct *ArgusModel;
 
   char *ArgusInputFilter;
  
   struct timeval ArgusStartTime, ArgusEndTime, lasttime;

   int ArgusSnapLength, ArgusThisLength;
   unsigned char *ArgusThisSnapEnd;

   unsigned char ArgusInterfaceType;
   unsigned char ArgusInterfaceStatus;
  
   int Argustflag, sNflag, eNflag, kflag, pflag, uflag;
   float Tflag;

   pcap_if_t *ArgusPacketDevices;
   pcap_if_t *ArgusDevice;
  
   int ArgusInterfaceIndex, ArgusThisIndex, ArgusInterfaces;
   struct ArgusInterfaceStruct ArgusInterface[ARGUS_MAXINTERFACE];

   int ArgusInputPacketFileType;
   int ArgusReadingOffLine;
   int Argusbpflag;
  
   FILE *ArgusPacketInput;
 
   int ArgusSnapLen, ArgusOflag, Arguspflag;
   char **ArgusArgv;
   int ArgusOptind;

   char *ArgusWriteOutPacketFile;
   pcap_dumper_t *ArgusPcapOutFile;
};

int ArgusSnoopRead (struct ArgusSourceStruct *);

void ArgusIpPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusArcnetPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusEtherPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusTokenPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusAtmClipPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusLoopPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusHdlcPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusSlipPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppBsdosPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusFddiPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusATMPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusSllPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppHdlcPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPppEtherPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void Argus802_11Packet (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusLtalkPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusPrismPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void Argus802_11RadioPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void Argus802_11RadioAvsPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);
void ArgusNullPacket (u_char *user, const struct pcap_pkthdr *h, const u_char *p);


struct callback {
   pcap_handler function;
   int type;
   char *fname;
};

int ArgusOpenInputPacketFile(struct ArgusSourceStruct *, char *);
pcap_handler Arguslookup_pcap_callback (int);
void Argusbpf_dump(struct bpf_program *, int);

void setArgusRealTime (struct ArgusSourceStruct *, float value);
float getArgusRealTime (struct ArgusSourceStruct *);

void setArgusMoatTshFile (struct ArgusSourceStruct *, int value);
int getArgusMoatTshFile (struct ArgusSourceStruct *);

void setArgusWriteOutPacketFile (struct ArgusSourceStruct *, char *);
void ArgusGetPackets (struct ArgusSourceStruct *);

unsigned char getArgusInterfaceType(struct ArgusSourceStruct *);
void setArgusInterfaceType(struct ArgusSourceStruct *, unsigned char);
 
unsigned char getArgusInterfaceStatus(struct ArgusSourceStruct *);
void setArgusInterfaceStatus(struct ArgusSourceStruct *, unsigned char);


#if defined(ArgusSource)

static struct callback ArgusSourceCallbacks[] = {
   { ArgusArcnetPacket,    DLT_ARCNET,      "ArgusArcnetPacket()" },
   { ArgusEtherPacket,     DLT_EN10MB,      "ArgusEtherPacket()" },
   { ArgusTokenPacket,     DLT_IEEE802,     "ArgusTokenPacket()" },
   { ArgusSlipPacket,      DLT_SLIP,        "ArgusSlipPacket()" },
   { ArgusSlipPacket,      DLT_SLIP_BSDOS,  "ArgusSlipPacket()" },
   { ArgusPppPacket,       DLT_PPP,         "ArgusPppPacket()" },
   { ArgusPppBsdosPacket,  DLT_PPP_BSDOS,   "ArgusPppBsdosPacket()" },
   { ArgusFddiPacket,      DLT_FDDI,        "ArgusFddiPacket()" },
   { ArgusATMPacket,       DLT_ATM_RFC1483, "ArgusATMPacket()" },
   { ArgusIpPacket,        DLT_RAW,         "ArgusIpPacket()" },
   { ArgusNullPacket,      DLT_NULL,        "ArgusNullPacket()" },
#ifdef DLT_LANE8023
   { ArgusLanePacket,      DLT_LANE8023,    "ArgusLanePacket()" },
#endif
#ifdef DLT_CIP
   { ArgusCipPacket,       DLT_CIP,         "ArgusCipPacket()" },
#endif
#ifdef DLT_ATM_CLIP
   { ArgusAtmClipPacket,   DLT_ATM_CLIP,    "ArgusAtmClipPacket()" },
#endif
#ifdef DLT_LINUX_SLL
   { ArgusSllPacket,       DLT_LINUX_SLL,   "ArgusSllPacket()" },
#endif
#ifdef DLT_LOOP
   { ArgusLoopPacket,      DLT_LOOP,        "ArgusLoopPacket()" },
#endif
#ifdef DLT_C_HDLC
   { ArgusHdlcPacket,      DLT_C_HDLC,      "ArgusHdlcPacket()" },
#endif
#ifdef DLT_HDLC
   { ArgusHdlcPacket,      DLT_HDLC,        "ArgusHdlcPacket()" },
#endif
#ifdef DLT_PPP_SERIAL
   { ArgusPppHdlcPacket,   DLT_PPP_SERIAL,  "ArgusPppHdlcPacket()" },
#endif
#ifdef DLT_PPP_ETHER
   { ArgusPppEtherPacket,  DLT_PPP_ETHER,   "ArgusPppEtherPacket()" },
#endif
#ifdef DLT_LINUX_SLL
   { ArgusSllPacket,       DLT_LINUX_SLL,   "ArgusSllPacket()" },
#endif
#ifdef DLT_IEEE802_11
   { Argus802_11Packet,    DLT_IEEE802_11,  "Argus802_11Packet()"},
#endif
#ifdef DLT_PRISM_HEADER
   { ArgusPrismPacket,     DLT_PRISM_HEADER, "ArgusPrismPacket()" },
#endif
#ifdef DLT_IEEE802_11_RADIO
   { Argus802_11RadioPacket, DLT_IEEE802_11_RADIO, "Argus802_11RadioPacket()" },
#endif
#ifdef DLT_IEEE802_11_RADIO_AVS
   { Argus802_11RadioAvsPacket, DLT_IEEE802_11_RADIO_AVS, "Argus802_11RadioAvsPacket()" },
#endif
#ifdef DLT_LTALK
   { ArgusLtalkPacket,     DLT_LTALK,       "ArgusLtalkPacket()" },
#endif
   { NULL, 0, NULL},
};

extern int Argustflag;
 
struct ArgusSourceStruct *ArgusSourceTask = NULL;

struct ArgusSourceStruct *ArgusNewSource(struct ArgusModelerStruct *);
void ArgusInitSource(struct ArgusSourceStruct *);
int ArgusCloseSource(struct ArgusSourceStruct *);

void setArgusOutputTask(void);
void setArgusModeler(struct ArgusSourceStruct *);

 
struct ArgusOutputStruct *getArgusOutputTask(void);
struct ArgusModelerStruct *getArgusModeler(struct ArgusSourceStruct *);

int getArgusSnapLen(struct ArgusSourceStruct *);
void setArgusSnapLen(struct ArgusSourceStruct *, int);

int getArgusbpflag(struct ArgusSourceStruct *);
int getArguspflag(struct ArgusSourceStruct *);
int getArgusOflag(struct ArgusSourceStruct *);

void setArgusbpflag(struct ArgusSourceStruct *, int);
void setArguspflag(struct ArgusSourceStruct *, int);
void setArgusOflag(struct ArgusSourceStruct *, int);

void setArgusArgv(struct ArgusSourceStruct *, char **);
void setArgusOptind(struct ArgusSourceStruct *, int);

void setArgusDevice(struct ArgusSourceStruct *, char *);
void setArgusInfile(struct ArgusSourceStruct *, char *);
void setArgusrfile(struct ArgusSourceStruct *, char *);
void setArgusrFile(struct ArgusSourceStruct *, char *);

char *getArgusDevice(struct ArgusSourceStruct *);
char *getArgusInfile(struct ArgusSourceStruct *);
char *getArgusrfile(struct ArgusSourceStruct *);

void clearArgusDevice(struct ArgusSourceStruct *);

static char *ArgusCopyArgv (char **);

int ArgusCreatePktFromFddi(const struct fddi_header *, struct ether_header *, int);


#else /* defined(ArgusSource) */

extern struct ArgusSourceStruct *ArgusSourceTask;

extern long long ArgusTotalPkts;
extern long long ArgusLastPkts;
extern long long ArgusTotalDrop;
extern long long ArgusLastDrop;
extern long long ArgusTotalBytes;
extern long long ArgusLastBytes;

extern struct ArgusSourceStruct *ArgusSourceTask;

extern struct ArgusSourceStruct *ArgusNewSource(struct ArgusModelerStruct *);
extern void ArgusInitSource(struct ArgusSourceStruct *);
extern int ArgusCloseSource(struct ArgusSourceStruct *);

extern struct ArgusOutputStruct *getArgusOutputTask(struct ArgusSourceStruct *);
extern void setArgusOutputTask(struct ArgusSourceStruct *);

extern struct ArgusModelerStruct *getArgusModeler(struct ArgusSourceStruct *);
extern void setArgusModeler(struct ArgusSourceStruct *);

extern int getArgusSnapLen(struct ArgusSourceStruct *);
extern void setArgusSnapLen(struct ArgusSourceStruct *, int);

extern int getArgusbpflag(struct ArgusSourceStruct *);
extern int getArguspflag(struct ArgusSourceStruct *);
extern int getArgusOflag(struct ArgusSourceStruct *);
extern int getArgusMoatTshFile (struct ArgusSourceStruct *);

extern void setArgusbpflag(struct ArgusSourceStruct *, int);
extern void setArguspflag(struct ArgusSourceStruct *, int);
extern void setArgusOflag(struct ArgusSourceStruct *, int);
extern void setArgusMoatTshFile (struct ArgusSourceStruct *, int value);

extern void setArgusWriteOutPacketFile (struct ArgusSourceStruct *, char *);

extern void setArgusArgv(struct ArgusSourceStruct *, char **);
extern void setArgusOptind(struct ArgusSourceStruct *, int);

extern void setArgusDevice(struct ArgusSourceStruct *, char *);
extern void setArgusInfile(struct ArgusSourceStruct *, char *);
extern void setArgusrfile(struct ArgusSourceStruct *, char *);

extern char *getArgusDevice(struct ArgusSourceStruct *);
extern char *getArgusInfile(struct ArgusSourceStruct *);
extern char *getArgusrfile(struct ArgusSourceStruct *);

extern void clearArgusDevice(struct ArgusSourceStruct *);

#endif
#endif /* #ifndef ArgusSource_h */
