/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: //depot/argus/argus-3.0/clients/include/rasplit.h#10 $
 * $DateTime: 2006/03/31 13:25:33 $
 * $Change: 793 $
 */

#ifndef RaSplit_h
#define RaSplit_h

#include <unistd.h>
#include <stdlib.h>

#include <signal.h>
#include <string.h>

#include <netinet/in.h>

#include <argus_util.h>
#include <argus_client.h>
#include <argus_namedb.h>
#include <argus_filter.h>
#include <argus_main.h>

#include <ctype.h>
 
#define ARGUSSECONDS		-1 
#define ARGUSMINUTE		0
#define ARGUSHOURLY		1 
#define ARGUSDAILY		2
#define ARGUSWEEKLY		3
#define ARGUSMONTHLY		4 
#define ARGUSNNUALY		5 
             
#define ARGUSSPLITMODENUM	9
#define ARGUSSPLITTIME		0
#define ARGUSSPLITCOUNT		1
#define ARGUSSPLITSIZE		2
#define ARGUSSPLITFLOW		3
#define ARGUSSPLITPATTERN	4

#define ARGUSSPLITNOMODIFY	5
#define ARGUSSPLITSOFT		6
#define ARGUSSPLITZERO		7
#define ARGUSSPLITRATE		8

#define ARGUSSPLITYEAR		1
#define ARGUSSPLITMONTH		2
#define ARGUSSPLITWEEK		3
#define ARGUSSPLITDAY		4
#define ARGUSSPLITHOUR		5
#define ARGUSSPLITMINUTE		6
#define ARGUSSPLITSECOND		7

#if defined(ArgusClient)

char *RaSplitModes[ARGUSSPLITMODENUM] = { 
  "time",
  "count",  
  "size",    
  "flow",    
  "pattern",    
  "nomodify",    
  "soft",    
  "zero",    
  "rate",    
};

#else

extern char *RaSplitModes[ARGUSSPLITMODENUM];

#endif
 
char *RaSplitFilename (struct ArgusAdjustStruct *);
 
struct ArgusRecordStruct *ArgusAlignRecord(struct ArgusParserStruct *, struct ArgusRecordStruct *, struct ArgusAdjustStruct *);
int RaProcessSplitOptions(struct ArgusParserStruct *, char *, int, struct ArgusRecordStruct*); 

#endif
