
#ifndef _FILEITEM_H
#define _FILEITEM_H

#include <string>

#include "config.h"
#include "lockable.h"
#include <header.h>

// Life line (process states) of a file description item
#define FIST_FRESH 		0
#define FIST_INITED		1
#define FIST_DLPENDING		4
#define FIST_DLGOTHEAD		8
#define FIST_DLRECEIVING	16
#define FIST_COMPLETE		32
// usually unreachable states
#define FIST_ERROR 			999
#define FIST_ERRNOUSER		9999

// some fileitem members need to know them...
class fileitem;
typedef SHARED_PTR<fileitem> tFileItemPtr;

class fileitem : public condition
{

public:
	
	virtual ~fileitem();
	
	// initialize file item, return the status
	virtual FiStatus Setup(bool bDynType);
	
	virtual int GetFileFd();
	uint64_t GetTransferCount();
	// send helper like wrapper for sendfile. Just declare virtual here to make it better customizable later.
	virtual ssize_t SendData(int confd, int filefd, off_t &nSendPos, size_t nMax2SendNow);
	
	// downloader instruments
	
	virtual bool DownloadStartedStoreHeader(const header & h, const char *pNextData);
	void IncDlRefCount();
	void DecDlRefCount(const mstring & sReasonStatusLine);
	//virtual void SetFailureMode(const mstring & message, FiStatus fist=FIST_ERROR,
	//	bool bOnlyIfNoDlRunnuning=false);
	
	/*!
	 * \return true IFF ok and caller might continue. False -> caller should abort.
	 */
	virtual bool StoreFileData(const char *data, unsigned int size);
	header const & GetHeaderUnlocked();
	inline header GetHeader() { setLockGuard; return m_head; }
	mstring GetHttpMsg();
	
	FiStatus GetStatus() { setLockGuard; return status; }
	FiStatus GetStatusUnlocked(off_t &nGoodDataSize) { nGoodDataSize = m_nSizeChecked; return status; }
	void ResetCacheState();
	
	uint64_t m_nIncommingCount;
	off_t m_nSizeSeen;
	mstring m_sPath, m_sKey;
	
	bool m_bCheckFreshness;

	bool m_bHeadOnly; // this is only good for special purposes

protected:

	bool m_bAllowStoreData;

	fileitem(mstring);
	off_t m_nSizeChecked;
	header m_head;
	int m_filefd;
	int m_nDlRefsCount;
	FiStatus status;

	////////////////////////////////
	// Item pool management methods
	////////////////////////////////
public:
	// public constructor wrapper, get a unique object from the map
	static tFileItemPtr GetFileItem(mstring sPath); // also opens the cached file and increases reference count
	virtual void Unreg(); // decrease dependent user count

	//! Call Unreg directly, or return immediatly but call it few seconds later
	static void UnregOneASAP(tFileItemPtr);
	//! @return: true iff there is still something in the pool for later cleaning
	static time_t DoDelayedUnregAndCheck();

private:
	time_t m_nTimeExpireAt; //! when to consider this item obsolete
	static time_t m_nEarliestExpiration; //! when to consider a closer look for expired items
};

extern lockable mapLck;

#endif


