
#ifndef _ACFG_H
#define _ACFG_H

#include "config.h"
#include "meta.h"

class hostdata;

static const int RESERVED_DEFVAL = -4223;


struct ltstring
{
  bool operator()(const mstring &s1, const mstring &s2) const
  {
    return strcasecmp(s1.c_str(), s2.c_str()) < 0;
  }
};

typedef MYSTD::map<mstring, mstring, ltstring> NoCaseStringMap;

namespace acfg
{

extern mstring cachedir, logdir, confdir, fifopath, user, group, pidfile, 
reportpage, vfilepat, pfilepat, wfilepat, agentname, remoteport, adminauth, bindaddr, port, sUmask,
dontcacherq, dontcachetgt, dontcache, mirrorsrcs, requestapx;

extern int debug, offlinemode, foreground, verbose, stupidfs, forcemanaged, 
verboselog, extreshhold, exfailabort, tpstandbymax, tpthreadmax, dnscachetime, dlbufsize,
exporigin, logxff, oldupdate, recompbz2, nettimeout, updinterval, forwardsoap, dirperms, fileperms;

// processed config settings
extern tHttpUrl proxy_info;
extern mstring agentheader;

bool SetOption(const mstring &line, bool bQuiet=false);
void ReadConfigDirectory(const char*);

//! Prepare various things resulting from variable combinations, etc.
void PostProcConfig();

// TODO: document me
// throw away the rewritten part of the path, foo/debian/bla.deb -> bla.deb,
// no slash needed with backends...
				
const mstring * GetRepNameAndPathResidual(const tHttpUrl & in, mstring & sRetPathResidual);

/*
struct tBackendDesc : public tHttpUrl
{
	struct tHookHandler
	{
		virtual void PostponeDownCmd()=0;
		virtual void UpCmd()=0;
		virtual void PreUpCmd()=0;
	};
	tHookHandler *m_pHooks;
	inline tBackendDesc(const tHttpUrl& src) : tHttpUrl(src), m_pHooks(NULL) {};
	inline tBackendDesc() : m_pHooks(NULL) {};
};
*/

typedef struct { 
	const char *name; mstring *ptr;
	const char *warn; }
MapNameToString;

typedef struct { 
	const char *name; int *ptr;
	const char *warn; int base;}
MapNameToInt;

struct tRepoData
{
	MYSTD::vector<tHttpUrl> m_backends;

	// dirty little helper to execute custom actions when a jobs associates or forgets this data set
	struct IHookHandler
	{
		virtual void JobRelease()=0;
		virtual void JobConnect()=0;
	};
	IHookHandler *m_pHooks;
	tStrVec m_keyfiles;
	tRepoData() : m_pHooks(NULL) {};
	virtual ~tRepoData();
};

const tRepoData * GetBackendVec(const mstring * vname);

time_t ExecutePostponed();

extern tStrMap localdirs;
extern NoCaseStringMap mimemap;

extern mstring cacheDirSlash; // guaranteed to have a trailing path separator

mstring EncodeBase64Auth(const cmstring & s);
} // namespace acfg

namespace rechecks
{
#define FILE_PKG 0
#define FILE_INDEX 1
#define	FILE_INVALID 2
unsigned int GetFiletype(const mstring &);
bool MatchWhitelist(const mstring &);
bool MatchUncacheableRequest(const mstring &);
bool MatchUncacheableTarget(const mstring &);

bool CompileExpressions();
}

#endif
