
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>

#include <vector>
//#include <iostream>

#include "config.h"
#include "dirwalk.h"

using namespace MYSTD;

struct dnode
{
	dnode(dnode *parent) : m_parent(parent) {};
	void Walk(IFileHandler *);

	MYSTD::string sPath;
	dnode *m_parent;
	struct stat m_stinfo;
	
private:
	// not to be copied
	dnode& operator=(const dnode&);
	dnode(const dnode&);

};

void dnode::Walk(IFileHandler *h)
{
	if (stat(sPath.c_str(), &m_stinfo) < 0)
		return; // slight risk of missing information here... bug ignoring is safer
	
	if(S_ISREG(m_stinfo.st_mode))
	{
		h->ProcessRegular(sPath, m_stinfo);
		return;
	}
	else if(! S_ISDIR(m_stinfo.st_mode))
	{
		h->ProcessOthers(sPath, m_stinfo);
		return;
	}
	
	// ok, that's a directory, scan it and descend where needed
	// seen this in the path before? symlink cycle?
	for(dnode *cur=m_parent; cur!=NULL; cur=cur->m_parent)
	{
		if (m_stinfo.st_dev == cur->m_stinfo.st_dev && m_stinfo.st_ino == cur->m_stinfo.st_ino)
			return;
	}
	
//	cerr << "Opening: " << sPath<<endl;
	DIR *dir = opendir(sPath.c_str());
	if (!dir) // weird, whatever... ignore...
		return;
	
	struct dirent *dp;
	dnode childbuf(this);
	
	while ( NULL != (dp = readdir(dir)) )
	{
		if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, ".."))
		{
			childbuf.sPath=sPath+string(SZPATHSEP)+dp->d_name;
			childbuf.Walk(h);
		}
	}
	
//	cerr << "Closing: " << sPath<<endl;
	closedir(dir);
}



void DirectoryWalk(string & sRoot, IFileHandler *h)
{
	dnode root(NULL);
	root.sPath=sRoot;
	root.Walk(h);
}

