#ifndef PKGIMPORT_H_
#define PKGIMPORT_H_

//! Reuses lots of processing code
#include "expiration.h"

#include <sys/stat.h>
#include <time.h>
#include <string.h>

/*!
 *  Two maps mapping in different directions:
	-	fingerprints pointing to file info description vector,
 		created by file scan+identification
 	-	when reusing old fingerprints, a file info description is mapped
 		to stored fingerprint
*/

struct tFingerprint {
	off_t size;
	uint8_t sum[16];
};
struct ltfingerprint
{
	bool operator()(const tFingerprint &a, const tFingerprint &b)
	{
		if(a.size!=b.size) 
			return a.size<b.size;
		return(memcmp(a.sum, b.sum, 16)<0);
	}
};
struct tFInfo
{
	tFInfo() : fsize(0), mtime(0), bFileUsed(false) {};
	inline tFInfo(const MYSTD::string & s, off_t f, time_t m) : 
		sPath(s), fsize(f), mtime(m), bFileUsed(false) {};
	MYSTD::string sPath;
	off_t fsize;
	time_t mtime;
	bool bFileUsed;
};
struct ltcachekey
{
  bool operator()(const tFInfo &a, const tFInfo &b) const
  {
	  int rel(0);
#if defined(WINDOWS) || defined(WIN32)
#warning FIXME, make this use nocasestringmap
#endif
	  rel=a.sPath.compare(b.sPath);
	  if(rel) return rel<0;
	  if(a.fsize!=b.fsize) 
		  return a.fsize<b.fsize;
	  return a.mtime<b.mtime;
  }
};
typedef MYSTD::map<tFInfo, tFingerprint, ltcachekey> tFInfo2Fpr;
typedef tFInfo2Fpr::iterator tCmapIter;
typedef MYSTD::map<tFingerprint, tFInfo, ltfingerprint> tFpr2FInfo;
typedef tFpr2FInfo::iterator tImapIter;


class pkgimport : public expiration {

public:
	
	pkgimport(int);
	
	void Action(const MYSTD::string & src);
	
protected:
	// FileHandler
	void ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	void ProcessOther(const MYSTD::string &sPath, const struct stat &);
	void _HandlePkgEntry(const MYSTD::string & refererPath, const NoCaseStringMap &info);

private:
	bool m_bPickIfiles;
	tFpr2FInfo m_importFileMap;
	tFInfo2Fpr m_cacheMap;
	MYSTD::string m_sSrcPath;
	tStringMap m_csCache;
	
	bool LinkOrCopy(const MYSTD::string &from, const MYSTD::string &to);
	//void _ExtractLocationsFromVolFiles();
	void _GuessAndGetIfiles();
	
	void _LoadKeyCache();
	void _GetCachedKey(const MYSTD::string & sPath, const struct stat &stinfo, MYSTD::string & out);
	bool _StoreInCache(tImapIter);
		
};


#endif /*PKGIMPORT_H_*/
