
#ifndef _JOB_H
#define _JOB_H

#include "config.h"
#include "header.h"
#include <sys/types.h>

class fileitem;
typedef SHARED_PTR<fileitem> tFileItemPtr;

class con;

typedef enum {
	R_DONE=0,
	R_AGAIN=1,
	R_DISCON=2,
	R_NOTFORUS=3
} eJobResult;

typedef enum {
	STATE_FRESH,
	STATE_HEADER_SENT,
	STATE_SEND_PLAIN_DATA,
	STATE_FAILMODE,
	STATE_SEND_CHUNK_HEADER,
	STATE_SEND_CHUNK_DATA,
	STATE_NOWAYOUT,
	STATE_ALLDONE,
	STATE_SEND_BUFFER,
	STATE_ERRORCONT
} eJobState;

class job {
      

   public:

       MYSTD::string lpath, checksum; // relative local path and checksum, written by resolver

      job(header *h, con *pParent);
      ~job();
      //  __attribute__((externally_visible))  
      
      void PrepareDownload();
      
      /*
       * Start or continue returning the file.
       */
      eJobResult SendData(int confd);
  
      static void FixUri(MYSTD::string &sUri);
      
      const MYSTD::string & TakeCounts(off_t &nSizeIn, off_t &nSizeOut);
      
   private:
      
	  int m_filefd;
	  con *m_pParentCon;
      
      bool m_bChunkMode:1;
      bool m_bCloseCon:1;
      bool m_bIsHttp11:1;
      
      eJobState m_state, m_backstate;
      
      MYSTD::string m_sErrorMsgBuffer;
      MYSTD::string m_sPrependBuf;
      MYSTD::string m_sFileLoc; // local_relative_path_to_file
      MYSTD::string m_sMaintCmd;
      
      header *m_pReqHead, m_RespHead;
      
      tFileItemPtr m_pItem;
      off_t m_nSendPos, m_nRangeLast;
      off_t m_nAllDataCount;
      
      long m_nCachedMaxSize;
      
      unsigned int m_nChunkRemainingBytes;
      USHORT m_type; // file type, bit mask
      
      job(const job&);
      job & operator=(const job&);
};

#endif
