// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef POA_H
#define POA_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include "plugin.h"

class Parameter;
class Filter;
class Analyse;
class Report;
class AddrFilter;

namespace poa
{
	extern std::list<Filter *> filter_list;
	extern std::list<AddrFilter *> addrfilter_list;
	extern std::list<Analyse *> analyse_list;
	extern std::list<Report *> report_list;
	extern std::list<Plugin *> plugin_list;

	extern std::map<std::string, Parameter *> object_map;

	void addObject( Filter * no );
	void addObject( AddrFilter * no );
	void addObject( Analyse * no );
	void addObject( Report * no );
	void addObject( Plugin * no );
	bool existObject( const std::string &prefix );
	void dumpOP_List( Parameter * p, const bool html );
	void dumpObjectParameter( const bool html );

	bool initPlugins( void );
	bool filterPlugins( void );
	bool analysePlugins( void );
	bool freePlugins( void );

	bool beforeFilterPlugins( Filter * );
	bool afterFilterPlugins( Filter * );
	bool beforeAnalysePlugins( Analyse * );
	bool afterAnalysePlugins( Analyse * );

	bool execPlugin( Plugin::ps_e ( Plugin::*fp ) ( void ), Plugin::pa_e pa, const std::string &name );
	bool execFilterPlugin( Plugin::ps_e ( Plugin::*fp ) ( Filter * ), Plugin::pa_e pa, const std::string &name, Filter * f );
	bool execAnalysePlugin( Plugin::ps_e ( Plugin::*fp ) ( Analyse * ), Plugin::pa_e pa, const std::string &name, Analyse * a );
}

#endif

