// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "mfipanalyse.h"

mfipAnalyse::mfipAnalyse() :
		strPrefix( "mfip" ),
		strName( "Mailcount From IP" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics how many mails sent from an ip" )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
}

void mfipAnalyse::run( std::map<std::string, unity_t> * unity_map )
{
	std::map<std::string, long> mailip_c;
	std::map<std::string, unity_t>::const_iterator i;
	std::map<std::string, long>::const_iterator j;

	for( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		mailip_c[i->second.client]++;
	}
	// Convert from ip->count to count->ip
	for( j = mailip_c.begin(); j != mailip_c.end(); j++ )
		mailc_ip.insert( std::make_pair( j->second, j->first ) );
}

void mfipAnalyse::print( void )
{
	if ( !report ) return;

	std::multimap<long, std::string>::reverse_iterator i;
	int limit = getIntParam( "limit" );

	report->startNewReport( "Mailcount from ip - sent mails", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = fill space
	report->addCol( -1, Report::STRING, Report::LEFT, "from ip", Report::NONE );
	report->addCol( 9, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->printHeader();

	for( i = mailc_ip.rbegin(); i != mailc_ip.rend(); i++ )
	{
		report->printField( i->second );
		report->printField( i->first );
		if( --limit < 0 ) break;
	}
	report->printFooter();
}

void mfipAnalyse::free( void )
{
	mailc_ip.clear();
}
