/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_FILE_MANAGER_H_
#define _IANJUTA_FILE_MANAGER_H_

#include <glib-object.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_FILE_MANAGER (ianjuta_file_manager_get_type ())
#define IANJUTA_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_FILE_MANAGER, IAnjutaFileManager))
#define IANJUTA_IS_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_FILE_MANAGER))
#define IANJUTA_FILE_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_FILE_MANAGER, IAnjutaFileManagerIface))

#define IANJUTA_FILE_MANAGER_ERROR ianjuta_file_manager_error_quark()

/**
* IANJUTA_FILE_MANAGER_SELECTED_FILE
*
* Anjuta shell value set by file manager to the selected file.
*/
#define	IANJUTA_FILE_MANAGER_SELECTED_FILE	"file_manager_selected_file"


typedef struct _IAnjutaFileManager IAnjutaFileManager;
typedef struct _IAnjutaFileManagerIface IAnjutaFileManagerIface;


struct _IAnjutaFileManagerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*section_changed) (IAnjutaFileManager *obj, GFile* file);

	GFile* (*get_selected) (IAnjutaFileManager *obj, GError **err);
	void (*set_root) (IAnjutaFileManager *obj, const gchar *root_uri, GError **err);
	void (*set_selected) (IAnjutaFileManager *obj, GFile* file, GError **err);

};


GQuark ianjuta_file_manager_error_quark     (void);
GType  ianjuta_file_manager_get_type        (void);

GFile* ianjuta_file_manager_get_selected (IAnjutaFileManager *obj, GError **err);

void ianjuta_file_manager_set_root (IAnjutaFileManager *obj, const gchar *root_uri, GError **err);

void ianjuta_file_manager_set_selected (IAnjutaFileManager *obj, GFile* file, GError **err);


G_END_DECLS

#endif
