//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_WELCOMEWINDOW_WELCOMEWINDOW_H
#define GUI_WELCOMEWINDOW_WELCOMEWINDOW_H

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QPixmap;
class QLabel;
class QPushButton;
class QIconViewItem;
class Items;
class Item;

//======================
class WelcomeWindow : public QDialog
{
Q_OBJECT
//----------------------
public:
  WelcomeWindow( QWidget *parent=0, const char* name=0);
//----------------------
private slots:
  void itemClicked( QIconViewItem *item );
//----------------------
private:
  QGridLayout* grid;

  QLabel* sideImage;
  QLabel* welcomeTitle;
  QLabel* welcomeMessage;

  Items* items;
  Item *help, *updates, *upcoming;

  ///Close button
  QPushButton* closeButton;
//----------------------
};
//======================

#endif //GUI_WELCOMEWINDOW_WELCOMEWINDOW_H
