//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef GUI_EDITING_SELECTIONPLACEMENTINTERFACE_H
#define GUI_EDITING_SELECTIONPLACEMENTINTERFACE_H

//--------------------
//forward declarations
//--------------------

#include <qwidget.h>
#include <qimage.h>
#include <qpoint.h>
#include <qsize.h>

//=====================================
/*! \brief A selection region placement interface. */
//=====================================
class SelectionPlacementInterface : public QWidget
{
Q_OBJECT

public:
  ///Creates layout
  SelectionPlacementInterface(QString imageFilename,
                              QWidget *parent=0, 
                              const char* name=0);
                 
  ///Deletes objects
  ~SelectionPlacementInterface();
  
  ///Returns the selected region in image space
  QRect getSelectedRegion();

  ///Set the select region using image space coordinates
  void setSelectedRegion(QRect selection);
  
  virtual QSize sizeHint() const;
  virtual QSize minimumSizeHint() const;
  //----------------------
protected:
  void paintEvent( QPaintEvent *e);
  void mousePressEvent( QMouseEvent *e);
  void mouseReleaseEvent( QMouseEvent *);
  void mouseMoveEvent( QMouseEvent *e);
  //----------------------
private:
  ///convert rectangle from image coordinates to display coordinates
  QRect imageToDisplay( QRect r );

  ///util function used to determine if mouse is over selected region
  bool overRegion( QPoint p );
  
  ///util function used to center selection about mouse location
  void recenterSelection(QPoint mousePosition);
  
  ///Scaled image used for display purposes
  QImage scaledImage;
   
  ///Unselected scaled image (desaturated version of scaled image)
  QImage unselectedScaledImage;
  
  ///original image dimensions
  QSize origImageSize;  

  ///selection
  QRect selection;

  ///dragging the mouse only moves the selection if 
  ///the mouse button is pressed first over the selected region
  bool currentlyDragging;

  ///current mouse shape. by caching this value we avoid 
  ///resetting the mouse cursor every time it moves etc.
  bool currentMouseShapeIsDrag;
  //----------------------
signals:
  //emitted as the user drags the selection around
  void placementChanged( QRect );  
  //----------------------
};
//======================

#endif //GUI_EDITING_SELECTIONPLACEMENTINTERFACE_H
