<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.1">
     
<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write thumbnail html pages -->
<xsl:template match="album" mode="contactsheets">
<xsl:for-each select="subalbum">
  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_thumbs.html')}"> 
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <style type="text/html">
          &lt;!--
          A{text-decoration:none}
          --&gt;
        </style>
        <style type="text/css">
          &lt;!--
          h3 {font-size: 12pt; font-weight: bold; text-align: center}
          h4 {font-size: 10pt; font-weight: normal; text-align: center}
          h4.ital {font-size: 10pt; font-weight: normal; text-align: center}
          --&gt;
        </style>
        <title><xsl:value-of select="name"/></title>
      </head>
      <body>
        <center>
          <table border="0">
            <tr>
              <td width="450">
                <h3>
                  <xsl:value-of select="name"/>
                </h3>
                <h4>
                  <xsl:value-of select="description"/>
                </h4>
              </td>
            </tr>
          </table>
        </center>
        <h4>
          <script type="text/javascript" language="JavaScript">
          <![CDATA[
          <!-- HIDE FROM OLD BROWSERS
          document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">Begin Slide Show</a>")
          document.write("&nbsp;-&nbsp;")
          -->
          ]]>
          </script>
          <a href="Album.html">
            Album Index
          </a>
        </h4>
        <center>
          <table border="0">
            <tr>
              <xsl:for-each select="photo">
              <xsl:variable name="photoDescription" select="description"/>
              <td valign="top" width="220">
                <center>
                <table border="0">
                  <tr>
                    <td valign="top">
                      <center>

                       <!-- Disable expanding to large image in small web exports because they are not included! -->
                      <xsl:if test="$smallWebExport=1">
                        <img src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="$photoDescription"/>
                      </xsl:if>
                      <xsl:if test="$smallWebExport=0">
                        <a href="img/{$subalbumNumber}/{position()}.jpg">
                          <img src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="$photoDescription"/>
                        </a>
                      </xsl:if>

                      </center>
                    </td>
                  </tr>
                  <tr>
                    <td valign="bottom">
                      <center>

                      <!-- Disable expanding to large image in small web exports because they are not included! -->
                      <xsl:if test="$smallWebExport=1">
                        <xsl:value-of select="description"/>
                      </xsl:if>
                      <xsl:if test="$smallWebExport=0">
                        <a href="img/{$subalbumNumber}/{position()}.jpg">
                          <xsl:value-of select="description"/>
                        </a>
                      </xsl:if>

                      </center>
                    </td>
                  </tr>
                </table>
              </center>
              </td>
              <xsl:if test="not(position() mod 3)">
                <xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr&gt;</xsl:text>
              </xsl:if>
              </xsl:for-each>
              <xsl:call-template name="endRow">
                <xsl:with-param name="cellsLeft" select="(3 - (count(photo) mod 3))"/>
              </xsl:call-template>
            </tr>
          </table>
        </center>
        <h4 class="ital">
          (Generated by <a href="http://albumshaper.sourceforge.net">Album Shaper</a>, Classic theme)
        </h4>
      </body>
    </html>
  </xsl:document>
</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
