/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_MAINWINDOW_H
#define __GCS_MAINWINDOW_H

#include <list> // for list of drop targets

#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/colorbutton.h>
#include <gtkmm/actiongroup.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/menu.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/treemodel.h>
#include <boost/shared_ptr.hpp>
#include <libglademm.h>

#include "core/gcs-types.h"
#include "widgets/gcs-paletteview.h"

using namespace Gnome;

namespace gcs
{

    template <class T> class HistoryNavigation;

    namespace Widgets
    {
        class BookmarkList;
        class SchemeSelector;
        class SchemeBox;
    }

    namespace Dialogs
    {
        class AboutWindow;
    }

    class MainWindow : public Gtk::Window
    {
        public:
            MainWindow(GtkWindow *cobject, Glib::RefPtr<Glade::Xml>& refGlade);
            ~MainWindow(void);

            static MainWindow& Instance();
            void set_color(ColorPtr c);

        protected:
            // no copying allowed
            MainWindow(MainWindow& w);

            virtual void on_realize();

            // setup functions
            void init_actions(void);
            void init_ui(void);

            virtual void on_show(void);
            virtual bool on_delete_event(GdkEventAny* event);
            void quit(void);

            /* File Menu Actions */
            void on_action_file_new(void);
            void on_action_file_save(void);
            void on_action_file_export(void);
            void on_action_file_quit(void);

            /* Edit Menu Actions */
            void on_action_edit_prefs(void);

            /* Help Menu Actions */
            void on_action_help_contents(void);
            void on_action_help_about(void);

            /* other actions */
            void on_color_changed(void);
            void on_schemetype_changed(void);

            // history navigation
            void on_action_history_back(void);
            void on_action_history_fwd(void);

            // bookmark actions
            void on_action_add_bookmark(void);
            void on_action_remove_bookmark(void);
            void on_action_clear_bookmarks(void);
            void update_bookmark_actions(void);

            // lighten actions
            void on_action_lighten_scheme(void);
            void on_action_darken_scheme(void);
            void on_action_saturate_scheme(void);
            void on_action_desaturate_scheme(void);

            void on_action_randomize(void);
            void on_action_paste(void);
            void on_clipboard_received(const Gtk::SelectionData& data);
            void on_clipboard_received_targets(const Glib::StringArrayHandle& targets_array);
            void update_paste_status(void);
            gint rand_range(gint range);

            /* swatch popup menu */
            void on_action_use_color(void);

            void on_bookmarks_selection_changed(void);
            void on_schemebox_color_selected(ColorPtr pColor);

            virtual void on_drop_drag_data_received(const
                    Glib::RefPtr<Gdk::DragContext>& context, int x, int y,
                    const Gtk::SelectionData& selection_data, guint info,
                    guint time);

        private:
            Glib::RefPtr<Glade::Xml> m_glade;
            static MainWindow *m_instance;
            // for creating menus and toolbars
            Glib::RefPtr<Gtk::UIManager> m_refUIManager;
            Glib::RefPtr<Gtk::ActionGroup> m_refActionGroup;

            // Containers for layout
            Gtk::VBox *m_vbox_layout;
            Gtk::VBox *m_vbox_menu_toolbar;
            Gtk::VBox *m_vbox_main;
            Gtk::VBox *m_vbox_favorites;
            Gtk::VBox *m_scrolledwindow_favorites;
            Gtk::VBox *m_vbox_scheme_display;
            Gtk::HPaned *m_pane;

            // Menus and Toolbars
            Gtk::Menu *m_main_menu;
            Gtk::Toolbar *m_toolbar;
            Gtk::Toolbar *m_bookmark_bar;

            Gtk::ColorButton *m_color_button;
            Widgets::SchemeSelector *m_scheme_selector;
            Widgets::SchemeBox *m_scheme_box;
            Widgets::BookmarkList *m_bookmark_list;
            Widgets::PaletteView* m_palette_view;
            Glib::ustring m_palette_file;

            Gtk::Statusbar *m_statusbar;

            Dialogs::AboutWindow *m_pAbout;

            // NON-UI ELEMENTS
            HistoryNavigation<Glib::ustring> *m_pHistory;

            friend void clipboard_owner_changed(GtkClipboard* clipboard, GdkEvent* event, gpointer data);
    };


    void clipboard_owner_changed(GtkClipboard* clipboard, GdkEvent* event, gpointer data);

} // namespace gcs

#endif // __GCS_MAINWINDOW_H
