// ---------------------------------------------------------------------------
// - Linear.hpp                                                              -
// - afnix:mth module - generalized linear solver class definitions          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_LINEAR_HPP
#define  AFNIX_LINEAR_HPP

#ifndef  AFNIX_RMI_HPP
#include "Rmi.hpp"
#endif

namespace afnix {

  /// The Linear class is a general class designed to encapsulate various
  /// solver strategies. The implementation can be used to select a
  /// a particular solver or enable the execution of different one.
  /// The Cramer solver can also be enabled, although this is only usefull
  /// in debug mode.
  /// @author amaury darsch

  class Linear : public Object {
  private:
    /// the cramer solver flag
    bool d_csf;
    /// the maximum number of iteration
    long d_mni;

  public:
    /// create a default linear solver
    Linear (void);

    /// create a linear solver by cramer flag
    /// @param csf the cramer solver flag
    Linear (const bool csf);

    /// create a linear solver by cramer flag and iteration number
    /// @param csf the cramer solver flag
    /// @param mni the maximum iteration number
    Linear (const bool csf, const long mni);

    /// copy construct this solver
    /// @param that the object to copy
    Linear (const Linear& that);

    /// assign a solver to this one
    /// @param that the object to assign
    Linear& operator = (const Linear& that);

    /// @return the class name
    String repr (void) const;

    /// @return a clone of this object
    Object* clone (void) const;

    /// solve a system with several iterable solvers
    /// @param rhs the right handside
    /// @param lhs the left hanside
    Rvi* solve (const Rmi& lhs, const Rvi& rhs) const;

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
