// ---------------------------------------------------------------------------
// - Libpim.cpp                                                              -
// - afnix:pim module - declaration & implementation                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Libpim.hpp"
#include "Predpim.hpp"
#include "Function.hpp"
#include "Assistant.hpp"

namespace afnix {

  // initialize the afnix:pim module

  Object* init_afnix_pim (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the afnix:pim nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* gset = aset->mknset   ("pim");

    // bind all symbols in the afnix:pim nameset
    gset->symcst ("Slot",        new Meta (Slot::mknew));
    gset->symcst ("Appointer",   new Meta (Appointer::mknew));
    gset->symcst ("Assistant",   new Meta (Assistant::mknew));

    // bind the predicates
    gset->symcst ("slot-p",      new Function (pim_slotp));
    gset->symcst ("appointer-p", new Function (pim_apptp));
    gset->symcst ("assistant-p", new Function (pim_asstp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_pim (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_pim (interp, argv);
  }
}
