# ---------------------------------------------------------------------------
# - apx-rwstm                                                               -
# - afnix:apx read/write stream class module                                -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the read/write stream class
const afnix:apx:rwstm (class)

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# initialize the read/write stream
# @param is the input stream to use
# @param os the output stream to use

trans afnix:apx:rwstm:preset (is os) {
  # set the base object
  trans this:super (afnix:xml:XmlReader)
  # set the i/o stream
  const this:is is
  const this:os os
}

# ----------------------------------------------------------------------------
# - method section                                                          -
# ----------------------------------------------------------------------------

# @return true if the streams are still open

trans afnix:apx:rwstm:valid-p nil {
  is:valid-p
}

# @return the next available apx packet

trans afnix:apx:rwstm:read-apx-node nil {
  # reset the reader
  this:reset
  # parse the input stream
  this:parse this:is
  # get the root node
  this:get-root
}

# write an apx packet to the output stream
# @param node the apx node to write

trans afnix:apx:rwstm:write-apx-node (node) {
  node:write this:os
  this:os:write-eof
}

# @return the next available apx message

trans afnix:apx:rwstm:read-message nil {
  # get the root node
  const root (this:read-apx-node)
  # attach the root node to an apx root object
  const xapx (afnix:apx:root)
  xapx:attach-node root
  # here is the result
  eval xapx
}

# write a request message with the command name and arguments
# @param name the command name
# @param argl the argument list

trans afnix:apx:rwstm:send-request-message (name argl) {
  # create a new apx root note
  const xapx (afnix:apx:root)
  # add a request node
  const rqst (xapx:add-request-command name)
  # add the argument list
  rqst:add-argument-list argl
  # write the message
  this:write-apx-node xapx
}

# write a command message with the command
# @param cmd the command to send

trans afnix:apx:rwstm:send-command-message (cmd) {
  # create a new apx root note
  const xapx (afnix:apx:root)
  # add a request node
  xapx:add-request-command cmd
  # write the message
  this:write-apx-node xapx
}

# write a message with a status code and a payload
# @param code the reply status code
# @param payl the reply payload

trans afnix:apx:rwstm:send-reply-message (code payl) {
  # create a new apx root note
  const xapx (afnix:apx:root)
  # add a reply node
  const rply (xapx:add-reply-status code)
  # set the reply payload
  rply:set-payload-node payl
  # write the message
  this:write-apx-node xapx
}
