# ---------------------------------------------------------------------------
# - apx-nrqst                                                               -
# - afnix:apx request node class module                                     -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the request node class
const afnix:apx:request (class)

# ----------------------------------------------------------------------------
# - public section                                                          -
# ----------------------------------------------------------------------------

# the request tag name
const AFNIX:APX:XML-RQST-NAME "apx:request"

# ----------------------------------------------------------------------------
# - private section                                                          -
# ----------------------------------------------------------------------------

# the request command/argument tag name
const AFNIX:APX:XML-RCMD-NAME "apx:cmd"
const AFNIX:APX:XML-RARG-NAME "apx:arg"

# the request command/argument attribute name
const AFNIX:APX:XML-RNAM-ATTR "name"
const AFNIX:APX:XML-RVAL-ATTR "value"

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# initialize the apx request node

trans afnix:apx:request:preset nil {
  # set the base message object
  trans this:super (afnix:apx:mesg AFNIX:APX:XML-RQST-NAME)
}

# ----------------------------------------------------------------------------
# - method section                                                          -
# ----------------------------------------------------------------------------

# add a command value in the request node
# @param value the command value to set

trans afnix:apx:request:set-command (value) {
  # get the head node
  const head (this:get-head-node)
  # check if the command node exists
  if (head:child-p AFNIX:APX:XML-RCMD-NAME) {
    throw "apx-error" "command already exists in request node"
  }
  # create a command tag
  const rcmd (afnix:xml:XmlTag AFNIX:APX:XML-RCMD-NAME)
  rcmd:set-attribute AFNIX:APX:XML-RNAM-ATTR value
  # add the node to the head
  head:add-child rcmd
}

# get the request command node

trans afnix:apx:request:get-command-node nil {
  # get the head node
  const head (this:get-head-node)
  # get the command node
  head:lookup-child AFNIX:APX:XML-RCMD-NAME
}

# get the request command value

trans afnix:apx:request:get-command-value nil {
  # get the command node
  const rcmd (this:get-command-node)
  # get the command attribute value
  rcmd:get-attribute-value AFNIX:APX:XML-RNAM-ATTR
}

# add a command agument in the request node
# @param value the argument value to add

trans afnix:apx:request:add-argument-value (value) {
  # get the head node
  const head (this:get-head-node)
  # create a argument tag
  const rarg (afnix:xml:XmlTag AFNIX:APX:XML-RARG-NAME)
  rarg:set-attribute AFNIX:APX:XML-RVAL-ATTR value
  # add the node to the head
  head:add-child rarg
}

# add a command agument in the request node by name and value
# @param name  the argument name  to add
# @param value the argument value to add

trans afnix:apx:request:add-argument-name-value (name value) {
  # get the head node
  const head (this:get-head-node)
  # check if the argument node exists
  if (head:child-p AFNIX:APX:XML-RARG-NAME AFNIX:APX:XML-RNAM-ATTR name) {
    throw "apx-error" "argument already exists in request node"
  }
  # create a argument tag
  const rarg (afnix:xml:XmlTag AFNIX:APX:XML-RARG-NAME)
  rarg:set-attribute AFNIX:APX:XML-RNAM-ATTR name
  rarg:set-attribute AFNIX:APX:XML-RVAL-ATTR value
  # add the node to the head
  head:add-child rarg
}

# add an argument list
# @param argl the argument list to add

trans afnix:apx:request:add-argument-list (argl) {
  # make sure we have a property list
  assert true (plist-p argl)
  # loop in the attribute list
  for (attr) (argl) {
    trans name (attr:get-name)
    trans pval (attr:get-value)
    this:add-argument-name-value name pval
  }
}

# get the request arguments nodes

trans afnix:apx:request:get-argument-node-vector nil {
  # get the head node
  const head (this:get-head-node)
  # select the argument nodes
  afnix:apx:select-children-by-name head AFNIX:APX:XML-RARG-NAME
}

# get the request argument values

trans afnix:apx:request:get-argument-vector nil {
  # get the argument nodes vector
  const xvec (this:get-argument-node-vector)
  # create a result list
  const argv (Vector)
  # loop in each node
  for (node) (xvec) {
    argv:append (node:get-attribute-value AFNIX:APX:XML-RVAL-ATTR)
  }
  # here is the result
  eval argv
}

# get the request argument value by name
# @param name the argument name

trans afnix:apx:request:get-argument-name-value (name) {
  # get the argument nodes vector
  const xvec (this:get-argument-node-vector)
  # loop in each node
  for (node) (xvec) {
    if (node:attribute-p AFNIX:APX:XML-RNAM-ATTR name) {
      return (node:get-attribute-value AFNIX:APX:XML-RVAL-ATTR)
    }
  }
  # not found
  throw "apx-error" (+ "invalid argument name " name)
}

# get the request argument list

trans afnix:apx:request:get-argument-list nil {
  # get the argument nodes vector
  const xvec (this:get-argument-node-vector)
  # create a result list
  const argl (Plist)
  # loop in each node
  for (node) (xvec) {
    # check for a name attribute
    if (node:attribute-p AFNIX:APX:XML-RNAM-ATTR) {
      # get the name/value attribute
      trans name (node:get-attribute-value AFNIX:APX:XML-RNAM-ATTR)
      trans pval (node:get-attribute-value AFNIX:APX:XML-RVAL-ATTR)
      # add the pair in the result list
      argl:set name pval
    }
  }
  # here is the result
  eval argl
}
