# ---------------------------------------------------------------------------
# - apx-nroot                                                               -
# - afnix:apx root node class module                                        -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the root node class
const afnix:apx:root (class)

# ----------------------------------------------------------------------------
# - private section                                                          -
# ----------------------------------------------------------------------------

const AFNIX:APX:XML-ROOT-NAME "apx"
const AFNIX:APX:XML-ROOT-ATTR "xmlns:apx"
const AFNIX:APX:XML-ROOT-XNSP "http://www.afnix.org/schema"

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# initialize the apx root node

trans afnix:apx:root:preset nil {
  # set the base object
  trans this:super (afnix:xml:XmlRoot)
  # preinitialize the node
  this:preini
}

# pre-initialize the node

trans afnix:apx:root:preini nil {
  # add the xml declaration
  this:add-child (afnix:xml:XmlDecl)
  # create the apx tag node
  const node (afnix:xml:XmlTag AFNIX:APX:XML-ROOT-NAME)
  # set the namespace
  node:set-attribute AFNIX:APX:XML-ROOT-ATTR AFNIX:APX:XML-ROOT-XNSP
  # add the apx tag node
  this:add-child node
}

# ----------------------------------------------------------------------------
# - method section                                                          -
# ----------------------------------------------------------------------------

# @return the apx node

trans afnix:apx:root:get-apx-node nil {
  this:lookup-child AFNIX:APX:XML-ROOT-NAME
}

# attach a root node to this instance
# @param node the node to attach

trans afnix:apx:root:attach-node (node) {
  assert true (afnix:xml:root-p node)
  trans this:super node
}

# add a new request to the root node

trans afnix:apx:root:add-request nil {
  # create a new request node
  const rqst (afnix:apx:request)
  # get the apx node
  const node (this:get-apx-node)
  # add the request to the node
  node:add-child (rqst:get-base-node)
  # here is the request
  eval rqst
}

# add a new request to the root node
# @param value the request command value

trans afnix:apx:root:add-request-command (value) {
  # create a new request
  const rqst (this:add-request)
  # set the command value
  rqst:set-command value
  # here is the request
  eval rqst
}

# @return the request list in the form of a vector

trans afnix:apx:root:get-request-list nil {
  # select the children nodes that matches the name
  const node (this:get-apx-node)
  const xsel (afnix:apx:select-children-by-name node AFNIX:APX:XML-RQST-NAME)
  # create the result vector
  const result (Vector)
  for (n) (xsel) {
    trans rqst (afnix:apx:request)
    rqst:attach-node n
    result:append rqst
  }
  # here is the final encapsulated vector
  eval result
}

# add a new reply to the root node

trans afnix:apx:root:add-reply nil {
  # create a new reply node
  const rply (afnix:apx:reply)
  # get the apx node
  const node (this:get-apx-node)
  # add the reply to the node
  node:add-child (rply:get-base-node)
  # here is the reply
  eval rply
}

# add a new reply to the root node
# @param code the reply status code

trans afnix:apx:root:add-reply-status (code) {
  # create a new reply
  const rply (this:add-reply)
  # set the command value
  rply:set-status code
  # here is the reply
  eval rply
}

# @return the reply list in the form of a vector

trans afnix:apx:root:get-reply-list nil {
  # select the children nodes that matches the name
  const node (this:get-apx-node)
  const xsel (afnix:apx:select-children-by-name node AFNIX:APX:XML-RPLY-NAME)
  # create the result vector
  const result (Vector)
  for (n) (xsel) {
    trans rqst (afnix:apx:reply)
    rqst:attach-node n
    result:append rqst
  }
  # here is the final encapsulated vector
  eval result
}
