
//=============================================================================
/**
 *  @file    component_ss.cpp
 *
 *  $Id: component_ss.cpp 89018 2010-02-15 22:36:07Z parsons $
 *
 *  Visitor generating code for Components in the server skeleton.
 *
 *
 *  @author Jeff Parsons
 */
//=============================================================================

// ******************************************************
// Component visitor for server skeleton
// ******************************************************

be_visitor_component_ss::be_visitor_component_ss (be_visitor_context *ctx)
  : be_visitor_component (ctx)
{
}

be_visitor_component_ss::~be_visitor_component_ss (void)
{
}

int
be_visitor_component_ss::visit_component (be_component *node)
{
  be_visitor_context ctx (*this->ctx_);
  be_visitor_interface_ss visitor (&ctx);
  return visitor.visit_interface (node);
}

int
be_visitor_component_ss::visit_connector (be_connector *node)
{
  return this->visit_component (node);
}

