
//=============================================================================
/**
 *  @file    component_si.cpp
 *
 *  $Id: component_si.cpp 89018 2010-02-15 22:36:07Z parsons $
 *
 *  Visitor generating code for Components in the server inline.
 *
 *
 *  @author Jeff Parsons
 */
//=============================================================================

// ******************************************************
// Component visitor for server inline
// ******************************************************

be_visitor_component_si::be_visitor_component_si (be_visitor_context *ctx)
  : be_visitor_component (ctx)
{
}

be_visitor_component_si::~be_visitor_component_si (void)
{
}

int
be_visitor_component_si::visit_component (be_component *node)
{
  be_visitor_context ctx (*this->ctx_);
  be_visitor_interface_si visitor (&ctx);
  return visitor.visit_interface (node);
}

int
be_visitor_component_si::visit_connector (be_connector *node)
{
  return this->visit_component (node);
}

