!!****m* ABINIT/interfaces_12poisson
!! NAME
!! interfaces_12poisson
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/12poisson
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_12poisson

 interface
  subroutine Build_Kernel(n01,n02,n03,nfft1,nfft2,nfft3,hgrid,itype_scf,karrayout)
   use defs_basis
   integer, intent(in) :: itype_scf
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   real(dp), intent(in) :: hgrid
   real(dp), dimension(nfft1/2+1,nfft2/2+1,nfft3/2+1), intent(out) :: karrayout
  end subroutine Build_Kernel
 end interface

 interface
  subroutine Dimensions_FFT(n01,n02,n03,nfft1,nfft2,nfft3)
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(out) :: nfft1
   integer, intent(out) :: nfft2
   integer, intent(out) :: nfft3
  end subroutine Dimensions_FFT
 end interface

 interface
  subroutine karrayhalf_in(n01,n02,n03,n1k,n2k,n3k,nfft1,nfft2,nfft3,nd1,nd2,nd3,&  
     kernel,karrayhalf)
   use defs_basis
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(in) :: n1k
   integer, intent(in) :: n2k
   integer, intent(in) :: n3k
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   real(dp), dimension(2,(nd1+1)/2,nd2,nd3), intent(out) :: karrayhalf
   real(dp), dimension(n1k,n2k,n3k), intent(in) :: kernel
  end subroutine karrayhalf_in
 end interface

 interface
  subroutine kernel_recon(n1k,n2k,n3k,nfft1,nfft2,nfft3,nd1,nd2,nd3,zarray,karray)
   use defs_basis
   integer, intent(in) :: n1k
   integer, intent(in) :: n2k
   integer, intent(in) :: n3k
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   real(dp), dimension(n1k,n2k,n3k), intent(out) :: karray
   real(dp), dimension(2,(nd1+1)/2*nd2*nd3), intent(in) :: zarray
  end subroutine kernel_recon
 end interface

 interface
  subroutine fourier_dim(n,n_next)
   integer, intent(in) :: n
   integer, intent(out) :: n_next
  end subroutine fourier_dim
 end interface

 interface
  subroutine fft3d_init(n1,n2,n3,nd1,nd2,nd3,zin,z)
   use defs_basis
   integer :: n1
   integer :: n2
   integer :: n3
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp)  :: z(2,nd1,nd2,nd3)
   real(dp)  :: zin(2,n1,n2,n3)
  end subroutine fft3d_init
 end interface

 interface
  subroutine fft3d_vgl(n1,n2,n3,nd1,nd2,nd3,x,md1,md2,md3,y,scale,tta,ttm)
   use defs_basis
   integer :: md1
   integer :: md2
   integer :: md3
   integer :: n1
   integer :: n2
   integer :: n3
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp)  :: scale
   real(dp)  :: tta
   real(dp)  :: ttm
   real(dp)  :: x(2,nd1,nd2,nd3)
   real(dp)  :: y(2,md1,md2,md3)
  end subroutine fft3d_vgl
 end interface

 interface
  subroutine FFT(n1,n2,n3,nd1,nd2,nd3,z,isign,inzee)
   use defs_basis
   integer :: inzee
   integer :: isign
   integer :: n1
   integer :: n2
   integer :: n3
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp)  :: z(2,nd1*nd2*nd3,2)
  end subroutine FFT
 end interface

 interface
  subroutine fft3d_ctrig(n,trig,after,before,now,isign,ic)
   use defs_basis
   integer :: ic
   integer :: isign
   integer :: n
   integer :: after(7)
   integer :: before(7)
   integer :: now(7)
   real(dp)  :: trig(2,8192)
  end subroutine fft3d_ctrig
 end interface

 interface
  subroutine fft3d_fftstp(mm,nfft,m,nn,n,zin,zout,trig,after,now,before,isign)
   use defs_basis
   integer :: after
   integer :: before
   integer :: isign
   integer :: m
   integer :: mm
   integer :: n
   integer :: nfft
   integer :: nn
   integer :: now
   real(dp)  :: trig(2,8192)
   real(dp)  :: zin(2,mm,m)
   real(dp)  :: zout(2,nn,n)
  end subroutine fft3d_fftstp
 end interface

 interface
  subroutine fftrot(mm,nfft,m,nn,n,zin,zout,trig,after,now,before,isign)
   use defs_basis
   integer :: after
   integer :: before
   integer :: isign
   integer :: m
   integer :: mm
   integer :: n
   integer :: nfft
   integer :: nn
   integer :: now
   real(dp)  :: trig(2,8192)
   real(dp)  :: zin(2,mm,m)
   real(dp)  :: zout(2,n,nn)
  end subroutine fftrot
 end interface

 interface
  subroutine gequad(nterms, p, w, urange, drange, acc)
   use defs_basis
   integer, intent(in) :: nterms
   real(dp), intent(out) :: acc
   real(dp), intent(out) :: drange
   real(dp), intent(out) :: urange
   real(dp), intent(out) :: p(nterms)
   real(dp), intent(out) :: w(nterms)
  end subroutine gequad
 end interface

 interface
  subroutine PARtest_kernel(n01,n02,n03,nfft1,nfft2,nfft3,&  
    hgrid,karray,pot_ion,rhopot,iproc,nproc)
   integer :: iproc
   integer :: n01
   integer :: n02
   integer :: n03
   integer :: nfft1
   integer :: nfft2
   integer :: nfft3
   integer :: nproc
   real*8 :: hgrid
   real*8, dimension(nfft1,nfft2,nfft3/nproc) :: karray
   real*8, dimension(n01,n02,n03) :: pot_ion
   real*8, dimension(n01,n02,n03) :: rhopot
  end subroutine PARtest_kernel
 end interface

 interface
  subroutine calculate_pardimensions(n01,n02,n03,m1,m2,m3,n1,n2,n3,md1,md2,md3,nd1,nd2,nd3,nproc)
   integer, intent(out) :: m1
   integer, intent(out) :: m2
   integer, intent(out) :: m3
   integer, intent(out) :: md1
   integer, intent(out) :: md2
   integer, intent(out) :: md3
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(out) :: n1
   integer, intent(out) :: n2
   integer, intent(out) :: n3
   integer, intent(out) :: nd1
   integer, intent(out) :: nd2
   integer, intent(out) :: nd3
   integer, intent(in) :: nproc
  end subroutine calculate_pardimensions
 end interface

 interface
  subroutine ParPSolver_Kernel(n01,n02,n03,nd1,nd2,nd3,&  
    hgrid,kernelLOC,ixc,pot_ion,rhopot,ehartree,eexcu,vexcu,iproc,nproc)
   integer, intent(in) :: iproc
   integer, intent(in) :: ixc
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(inout) :: nd1
   integer, intent(inout) :: nd2
   integer, intent(inout) :: nd3
   integer, intent(in) :: nproc
   real*8, intent(out) :: eexcu
   real*8, intent(out) :: ehartree
   real*8, intent(in) :: hgrid
   real*8, intent(out) :: vexcu
   real*8, intent(in), dimension(nd1,nd2,nd3/nproc) :: kernelLOC
   real*8, intent(in), dimension(n01,n02,n03) :: pot_ion
   real*8, intent(inout), dimension(n01,n02,n03) :: rhopot
  end subroutine ParPSolver_Kernel
 end interface

 interface
  subroutine pconvxc_on(m1,m2,m3,n1,n2,n3,nd1,nd2,nd3,md1,md2,md3,iproc,nproc,&  
    rhopot,pot_ion,kernelloc,hgrid,ixc,ehartree,eexcu,vexcu)
   integer, intent(in) :: iproc
   integer, intent(in) :: ixc
   integer, intent(in) :: m1
   integer, intent(in) :: m2
   integer, intent(in) :: m3
   integer, intent(in) :: md1
   integer, intent(in) :: md2
   integer, intent(in) :: md3
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nproc
   real(kind=8), intent(inout) :: eexcu
   real(kind=8), intent(inout) :: ehartree
   real(kind=8), intent(in) :: hgrid
   real(kind=8), intent(inout) :: vexcu
   real(kind=8), dimension(nd1,nd2,nd3/nproc), intent(in) :: kernelloc
   real(kind=8), dimension(m1,m3,m2), intent(in) :: pot_ion
   real(kind=8), dimension(m1,m3,m2), intent(inout) :: rhopot
  end subroutine pconvxc_on
 end interface

 interface
  subroutine pconvxc_off(m1,m2,m3,n1,n2,n3,nd1,nd2,nd3,md1,md2,md3,iproc,nproc,&  
    rhopot,kernelloc,hgrid,ehartree)
   integer, intent(in) :: iproc
   integer, intent(in) :: m1
   integer, intent(in) :: m2
   integer, intent(in) :: m3
   integer, intent(in) :: md1
   integer, intent(in) :: md2
   integer, intent(in) :: md3
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nproc
   real(kind=8), intent(inout) :: ehartree
   real(kind=8), intent(in) :: hgrid
   real(kind=8), dimension(nd1,nd2,nd3/nproc), intent(in) :: kernelloc
   real(kind=8), dimension(m1,m3,m2), intent(inout) :: rhopot
  end subroutine pconvxc_off
 end interface

 interface
  subroutine enterdensity(rhopot,m1,m2,m3,md1,md2,md3,iproc,nproc,zf)
   integer, intent(in) :: iproc
   integer, intent(in) :: m1
   integer, intent(in) :: m2
   integer, intent(in) :: m3
   integer, intent(in) :: md1
   integer, intent(in) :: md2
   integer, intent(in) :: md3
   integer, intent(in) :: nproc
   real*8, dimension(0:m1-1,0:m3-1,0:m2-1), intent(in) :: rhopot
   real*8, dimension(0:md1-1,0:md3-1,0:md2/nproc-1), intent(out) :: zf
  end subroutine enterdensity
 end interface

 interface
  subroutine ParBuild_Kernel(n01,n02,n03,nfft1,nfft2,nfft3,n1k,n2k,n3k,hgrid,itype_scf,iproc,nproc,karrayoutLOC)
   integer, intent(in) :: iproc
   integer, intent(in) :: itype_scf
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(in) :: n1k
   integer, intent(in) :: n2k
   integer, intent(in) :: n3k
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   integer, intent(in) :: nproc
   real(kind=8), intent(in) :: hgrid
   real(kind=8), dimension(n1k,n2k,n3k/nproc), intent(out) :: karrayoutLOC
  end subroutine ParBuild_Kernel
 end interface

 interface
  subroutine convolxc_on(n1,n2,n3,nd1,nd2,nd3,md1,md2,md3,nproc,iproc,pot,zf&  
             ,zfpot_ion,scal,hgrid,ehartree,eexcu,vexcu)
   use defs_basis
   integer, intent(in) :: iproc
   integer, intent(in) :: md1
   integer, intent(in) :: md2
   integer, intent(in) :: md3
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nproc
   real(dp), intent(inout) :: eexcu
   real(dp), intent(inout) :: ehartree
   real(dp), intent(in) :: hgrid
   real(dp), intent(in) :: scal
   real(dp), intent(inout) :: vexcu
   real(dp), dimension(nd1,nd2,nd3/nproc), intent(in) :: pot
   real(dp), dimension(md1,md3,md2/nproc), intent(inout) :: zf
   real(dp), dimension(md1,md3,md2/nproc), intent(in) :: zfpot_ion
  end subroutine convolxc_on
 end interface

 interface
  subroutine convolxc_off(n1,n2,n3,nd1,nd2,nd3,md1,md2,md3,nproc,iproc,pot,zf&  
             ,scal,hgrid,ehartree)
   use defs_basis
   integer, intent(in) :: iproc
   integer, intent(in) :: md1
   integer, intent(in) :: md2
   integer, intent(in) :: md3
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nproc
   real(dp), intent(inout) :: ehartree
   real(dp), intent(in) :: hgrid
   real(dp), intent(in) :: scal
   real(dp), dimension(nd1,nd2,nd3/nproc), intent(in) :: pot
   real(dp), dimension(md1,md3,md2/nproc), intent(inout) :: zf
  end subroutine convolxc_off
 end interface

 interface
  subroutine multkernel(nd1,nd2,n1,n2,lot,nfft,jS,pot,zw)
   use defs_basis
   integer, intent(in) :: jS
   integer, intent(in) :: lot
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nfft
   real(dp), dimension(nd1,nd2), intent(in) :: pot
   real(dp), dimension(2,lot,n2), intent(inout) :: zw
  end subroutine multkernel
 end interface

 interface
  subroutine switch_upcorn(nfft,n2,lot,n1,lzt,zt,zw)
   use defs_basis
   integer :: lot
   integer :: lzt
   integer :: n1
   integer :: n2
   integer :: nfft
   real(dp)  :: zt(2,lzt,n1)
   real(dp)  :: zw(2,lot,n2)
  end subroutine switch_upcorn
 end interface

 interface
  subroutine mpiswitch_upcorn(j3,nfft,Jp2stb,J2stb,lot,n1,md2,nd3,nproc,zmpi1,zw)
   use defs_basis
   integer :: j2stb
   integer :: j3
   integer :: jp2stb
   integer :: lot
   integer :: md2
   integer :: n1
   integer :: nd3
   integer :: nfft
   integer :: nproc
   real(dp)  :: zmpi1(2,n1/2,md2/nproc,nd3/nproc,nproc)
   real(dp)  :: zw(2,lot,n1)
  end subroutine mpiswitch_upcorn
 end interface

 interface
  subroutine halfill_upcorn(md1,md3,lot,nfft,n3,zf,zw)
   use defs_basis
   integer :: lot
   integer :: md1
   integer :: md3
   integer :: n3
   integer :: nfft
   real(dp)  :: zf(md1,md3)
   real(dp)  :: zw(2,lot,n3/2)
  end subroutine halfill_upcorn
 end interface

 interface
  subroutine scramble_unpack(i1,j2,lot,nfft,n1,n3,md2,nproc,nd3,zw,zmpi2,cosinarr)
   use defs_basis
   integer, intent(in) :: i1
   integer, intent(in) :: j2
   integer, intent(in) :: lot
   integer, intent(in) :: md2
   integer, intent(in) :: n1
   integer, intent(in) :: n3
   integer, intent(in) :: nd3
   integer, intent(in) :: nfft
   integer, intent(in) :: nproc
   real(dp), dimension(2,n3/2), intent(in) :: cosinarr
   real(dp), dimension(2,n1,md2/nproc,nd3), intent(out) :: zmpi2
   real(dp), dimension(2,lot,n3/2), intent(in) :: zw
  end subroutine scramble_unpack
 end interface

 interface
  subroutine unscramble_pack(i1,j2,lot,nfft,n1,n3,md2,nproc,nd3,zmpi2,zw,cosinarr)
   use defs_basis
   integer, intent(in) :: i1
   integer, intent(in) :: j2
   integer, intent(in) :: lot
   integer, intent(in) :: md2
   integer, intent(in) :: n1
   integer, intent(in) :: n3
   integer, intent(in) :: nd3
   integer, intent(in) :: nfft
   integer, intent(in) :: nproc
   real(dp), dimension(2,n3/2), intent(in) :: cosinarr
   real(dp), dimension(2,n1,md2/nproc,nd3), intent(in) :: zmpi2
   real(dp), dimension(2,lot,n3/2), intent(out) :: zw
  end subroutine unscramble_pack
 end interface

 interface
  subroutine unswitch_downcorn(nfft,n2,lot,n1,lzt,zw,zt)
   use defs_basis
   integer :: lot
   integer :: lzt
   integer :: n1
   integer :: n2
   integer :: nfft
   real(dp)  :: zt(2,lzt,n1)
   real(dp)  :: zw(2,lot,n2)
  end subroutine unswitch_downcorn
 end interface

 interface
  subroutine unmpiswitch_downcorn(j3,nfft,Jp2stf,J2stf,lot,n1,md2,nd3,nproc,zw,zmpi1)
   use defs_basis
   integer :: j2stf
   integer :: j3
   integer :: jp2stf
   integer :: lot
   integer :: md2
   integer :: n1
   integer :: nd3
   integer :: nfft
   integer :: nproc
   real(dp)  :: zmpi1(2,n1/2,md2/nproc,nd3/nproc,nproc)
   real(dp)  :: zw(2,lot,n1)
  end subroutine unmpiswitch_downcorn
 end interface

 interface
  subroutine unfill_downcorn(md1,md3,lot,nfft,n3,zw,zf&  
     ,scal,ehartreetmp)
   use defs_basis
   integer, intent(in) :: lot
   integer, intent(in) :: md1
   integer, intent(in) :: md3
   integer, intent(in) :: n3
   integer, intent(in) :: nfft
   real(dp), intent(out) :: ehartreetmp
   real(dp), intent(in) :: scal
   real(dp), dimension(md1,md3),intent(inout) :: zf
   real(dp), dimension(2,lot,n3/2), intent(in) :: zw
  end subroutine unfill_downcorn
 end interface

 interface
  subroutine unfill_downcornxc_on(md1,md3,lot,nfft,n3,zw,zf&  
     ,zfpot_ion,factor,ehartree,eexcu,vexcu)
   use defs_basis
   integer, intent(in) :: lot
   integer, intent(in) :: md1
   integer, intent(in) :: md3
   integer, intent(in) :: n3
   integer, intent(in) :: nfft
   real(dp), intent(out) :: eexcu
   real(dp), intent(out) :: ehartree
   real(dp), intent(in) :: factor
   real(dp), intent(out) :: vexcu
   real(dp), dimension(md1,md3),intent(inout) :: zf
   real(dp), dimension(md1,md3),intent(in) :: zfpot_ion
   real(dp), dimension(2,lot,n3/2), intent(in) :: zw
  end subroutine unfill_downcornxc_on
 end interface

 interface
  subroutine kernelfft(n1,n2,n3,nd1,nd2,nd3,nproc,iproc,zf,zr)
   use defs_basis
   integer, intent(in) :: iproc
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nproc
   real(dp), dimension(nd1,n3,nd2/nproc), intent(in) :: zf
   real(dp), dimension(2,nd1,nd2,nd3/nproc), intent(inout) :: zr
  end subroutine kernelfft
 end interface

 interface
  subroutine mpiswitch_local(j3,nfft,Jp2st,J2st,lot,n1,nd2,nd3,nproc,zmpi1,zw)
   use defs_basis
   integer :: j2st
   integer :: j3
   integer :: jp2st
   integer :: lot
   integer :: n1
   integer :: nd2
   integer :: nd3
   integer :: nfft
   integer :: nproc
   real(dp)  :: zmpi1(2,n1,nd2/nproc,nd3/nproc,nproc)
   real(dp)  :: zw(2,lot,n1)
  end subroutine mpiswitch_local
 end interface

 interface
  subroutine inserthalf(nd1,nd3,lot,nfft,n3,zf,zw)
   use defs_basis
   integer :: lot
   integer :: n3
   integer :: nd1
   integer :: nd3
   integer :: nfft
   real(dp)  :: zf(nd1,n3)
   real(dp)  :: zw(2,lot,n3/2)
  end subroutine inserthalf
 end interface

 interface
  subroutine PSolver_hartree(dtset, iaction, nfft, ngfft, rhor, rprimd, vhartr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iaction
   integer,intent(in) :: nfft
   type(dataset_type),intent(in) :: dtset
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: rhor(nfft)
   real(dp),intent(out) :: vhartr(nfft)
  end subroutine PSolver_hartree
 end interface

 interface
  subroutine PSolver_Kernel(n01,n02,n03,nfft1,nfft2,nfft3,&  
     hgrid,karray,xc_on,pot_ion,rhopot,ehartree,eexcu,vexcu)
   use defs_basis
   integer, intent(in) :: n01
   integer, intent(in) :: n02
   integer, intent(in) :: n03
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   real(dp), intent(out) :: eexcu
   real(dp), intent(out) :: ehartree
   real(dp), intent(in) :: hgrid
   real(dp), intent(out) :: vexcu
   logical, intent(in) :: xc_on
   real(dp), intent(in), dimension(nfft1/2+1,nfft2/2+1,nfft3/2+1) :: karray
   real(dp), intent(in), dimension(n01,n02,n03) :: pot_ion
   real(dp), intent(inout), dimension(n01,n02,n03) :: rhopot
  end subroutine PSolver_Kernel
 end interface

 interface
  subroutine kernel_application(n1,n2,n3,nd1h,nd2,nd3,nfft1,nfft2,nfft3,zarray,karray,inzee)
   use defs_basis
   integer, intent(in) :: inzee
   integer, intent(in) :: n1
   integer, intent(in) :: n2
   integer, intent(in) :: n3
   integer, intent(in) :: nd1h
   integer, intent(in) :: nd2
   integer, intent(in) :: nd3
   integer, intent(in) :: nfft1
   integer, intent(in) :: nfft2
   integer, intent(in) :: nfft3
   real(dp), intent(in), dimension(nfft1/2+1,nfft2/2+1,nfft3/2+1) :: karray
   real(dp), intent(inout), dimension(2,nd1h,nd2,nd3,2) :: zarray
  end subroutine kernel_application
 end interface

 interface
  subroutine norm_ind(nd1,nd2,nd3,i1,i2,i3,ind)
   integer :: i1
   integer :: i2
   integer :: i3
   integer :: ind
   integer :: nd1
   integer :: nd2
   integer :: nd3
  end subroutine norm_ind
 end interface

 interface
  subroutine symm_ind(nd1,nd2,nd3,i1,i2,i3,ind)
   integer :: i1
   integer :: i2
   integer :: i3
   integer :: ind
   integer :: nd1
   integer :: nd2
   integer :: nd3
  end subroutine symm_ind
 end interface

 interface
  subroutine symm_ind3(nd1,nd2,nd3,i1,i2,i3,a1,a2,a3)
   integer :: a1
   integer :: a2
   integer :: a3
   integer :: i1
   integer :: i2
   integer :: i3
   integer :: nd1
   integer :: nd2
   integer :: nd3
  end subroutine symm_ind3
 end interface

 interface
  subroutine zarray_in(n01,n02,n03,nd1,nd2,nd3,density,zarray)
   use defs_basis
   integer :: n01
   integer :: n02
   integer :: n03
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp), dimension(n01,n02,n03) :: density
   real(dp), dimension(2,nd1,nd2,nd3) :: zarray
  end subroutine zarray_in
 end interface

 interface
  subroutine zarray_out(n01,n02,n03,nd1,nd2,nd3,&  
     rhopot,zarray,factor,hgrid,ehartree)
   use defs_basis
   integer :: n01
   integer :: n02
   integer :: n03
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp) :: ehartree
   real(dp) :: factor
   real(dp) :: hgrid
   real(dp), dimension(n01,n02,n03) :: rhopot
   real(dp), dimension(2*nd1,nd2,nd3) :: zarray
  end subroutine zarray_out
 end interface

 interface
  subroutine excpotu(n01,n02,n03,nd1_2,nd2,nd3,&  
     rhopot,pot_ion,zarray,factor,hgrid,ehartree,eexcu,vexcu)
   use defs_basis
   integer :: n01
   integer :: n02
   integer :: n03
   integer :: nd1_2
   integer :: nd2
   integer :: nd3
   real(dp) :: eexcu
   real(dp) :: ehartree
   real(dp) :: factor
   real(dp) :: hgrid
   real(dp) :: vexcu
   real(dp), dimension(n01,n02,n03) :: pot_ion
   real(dp), dimension(n01,n02,n03) :: rhopot
   real(dp), dimension(nd1_2,nd2,nd3) :: zarray
  end subroutine excpotu
 end interface

 interface
  subroutine check_symmetry(nd1,nd2,nd3,zarray,inzee)
   use defs_basis
   integer :: inzee
   integer :: nd1
   integer :: nd2
   integer :: nd3
   real(dp) :: zarray(2,nd1*nd2*nd3,2)
  end subroutine check_symmetry
 end interface

 interface
  subroutine test_kernel(n01,n02,n03,nfft1,nfft2,nfft3,&  
     hgrid,karray,pot_ion,rhopot)
   use defs_basis
   integer :: n01
   integer :: n02
   integer :: n03
   integer :: nfft1
   integer :: nfft2
   integer :: nfft3
   real(dp) :: hgrid
   real(dp), dimension(nfft1/2+1,nfft2/2+1,nfft3/2+1) :: karray
   real(dp), dimension(n01,n02,n03) :: pot_ion
   real(dp), dimension(n01,n02,n03) :: rhopot
  end subroutine test_kernel
 end interface

 interface
  subroutine scaling_function(itype,nd,nrange,a,x)
   use defs_basis
   integer, intent(in) :: itype
   integer, intent(in) :: nd
   integer, intent(out) :: nrange
   real(dp), dimension(0:nd), intent(out) :: a
   real(dp), dimension(0:nd), intent(out) :: x
  end subroutine scaling_function
 end interface

 interface
  subroutine wavelet_function(itype,nd,a,x)
   use defs_basis
   integer, intent(in) :: itype
   integer, intent(in) :: nd
   real(dp), dimension(0:nd), intent(out) :: a
   real(dp), dimension(0:nd), intent(out) :: x
  end subroutine wavelet_function
 end interface

 interface
  subroutine scf_recursion(itype,n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: itype
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion
 end interface

 interface
  subroutine for_trans_8(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_8
 end interface

 interface
  subroutine back_trans_8(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_8
 end interface


 interface
  subroutine scf_recursion_8(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_8
 end interface

 interface
  subroutine for_trans_14(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_14
 end interface

 interface
  subroutine back_trans_14(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_14
 end interface


 interface
  subroutine scf_recursion_14(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_14
 end interface

 interface
  subroutine for_trans_16(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_16
 end interface

 interface
  subroutine back_trans_16(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_16
 end interface


 interface
  subroutine scf_recursion_16(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_16
 end interface

 interface
  subroutine for_trans_20(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_20
 end interface

 interface
  subroutine back_trans_20(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_20
 end interface


 interface
  subroutine scf_recursion_20(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_20
 end interface

 interface
  subroutine for_trans_24(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_24
 end interface

 interface
  subroutine back_trans_24(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_24
 end interface


 interface
  subroutine scf_recursion_24(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_24
 end interface

 interface
  subroutine for_trans_30(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_30
 end interface

 interface
  subroutine back_trans_30(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_30
 end interface


 interface
  subroutine scf_recursion_30(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_30
 end interface

 interface
  subroutine for_trans_40(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_40
 end interface

 interface
  subroutine back_trans_40(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_40
 end interface


 interface
  subroutine scf_recursion_40(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_40
 end interface

 interface
  subroutine for_trans_50(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_50
 end interface

 interface
  subroutine back_trans_50(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_50
 end interface


 interface
  subroutine scf_recursion_50(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_50
 end interface

 interface
  subroutine for_trans_60(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_60
 end interface

 interface
  subroutine back_trans_60(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_60
 end interface


 interface
  subroutine scf_recursion_60(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_60
 end interface

 interface
  subroutine for_trans_100(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine for_trans_100
 end interface

 interface
  subroutine back_trans_100(nd,nt,x,y)
   use defs_basis
   integer, intent(in) :: nd
   integer, intent(in) :: nt
   real(dp), intent(in) :: x(0:nd-1)
   real(dp), intent(out) :: y(0:nd-1)
  end subroutine back_trans_100
 end interface


 interface
  subroutine scf_recursion_100(n_iter,n_range,kernel_scf,kern_1_scf)
   use defs_basis
   integer, intent(in) :: n_iter
   integer, intent(in) :: n_range
   real(dp), intent(out) :: kern_1_scf(-n_range:n_range)
   real(dp), intent(inout) :: kernel_scf(-n_range:n_range)
  end subroutine scf_recursion_100
 end interface

 interface
  subroutine razero(n,x)
   use defs_basis
   integer, intent(in) :: n
   real(dp), intent(out) :: x(n)
  end subroutine razero
 end interface

end module interfaces_12poisson
!!***
