/*
   Copyright (C) 2007 Will Franklin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#ifndef _MM_SUPPORTED
#define _MM_SUPPORTED

#include "../gameshared/gs_public.h"

#define ALLOW_UNREGISTERED_MM

#define ITEMS_NONE WEAP_NONE

typedef struct
{
	char *short_name;
	//int tag;
	float multiplier;
} mm_supported_items_t;

typedef struct
{
	char *short_name;
	int tag;
	int maxclients;
	int scorelimit;
	float timelimit;
	qboolean falldamage;
} mm_supported_gametypes_t;

extern mm_supported_items_t supported_items[];
extern mm_supported_gametypes_t supported_gametypes[];

qboolean MM_CheckItemExists( const char *name );
qboolean MM_CheckGameTypeByTag( int tag );
int      MM_GetGameTypeTagByName( const char *name );
char    *MM_GetGameTypeNameByTag( int tag );
void     MM_GetGameTypeInfo( int tag, int *maxclients, int *scorelimit, float *timelimit, qboolean *falldamage );

typedef enum
{
	TYPE_ANY,
	TYPE_DEPENDENT,

	TYPE_TOTAL
} mm_type_t;

#endif
