# -*- coding: utf-8 -*-

# Copyright (c) 2010 Lukas Hetzenecker <LuHe@gmx.at>

from PyQt4.QtCore import *
from PyQt4.QtSql import *
from lib.classes import *

class GeneralFormatter(QObject):
    def __init__(self,  parent,  main, 
                 contacts=Contacts.All,  
                 period=Period.Daily,  
                 graph=Graph.Yes,  
                 legend=Legend.Yes,  
                 thumbnails=Thumbnails.Yes,  
                 directory='./export/',  
                 order=Order.ASC, 
                 graphFormat=GraphFormat.PNG,  
                 exportContacts=None):
        QObject.__init__(self,  parent)
        
        self.main = main
        self.database = main.database
        
        self.contacts = contacts
        self.period = period
        self.graph = graph
        self.legend = legend
        self.thumbnails = thumbnails
        self.directory = directory
        self.order = order
        self.graphFormat = graphFormat
        self.exportContacts = exportContacts
        
        self.messageFiles = 0
    
        self.lastPeriod = QDate()
        self.files = list()
        
        if self.contacts == Contacts.ContactsWithMessages:
            self.contactList = list()
        elif self.contacts == Contacts.All:
            self.contactList = [contact for contact in self.database.contacts(True)] # Convert generator to list
        elif self.contacts == Contacts.Filter:
            self.contactList = self.exportContacts
        elif self.contacts == Contacts.None_:
            self.contactList = list()
    
    def orderString(self):
        if self.order == Order.ASC:
            return "ASC"
        return "DESC"
    
    def formatMessage(self,  message):
        c = message.contact()
        # Add this contact to list of messages with contacts if this filter is set
        if self.contacts == Contacts.ContactsWithMessages and c.idOnPhone() and c not in self.contactList:
            self.contactList.append(c)
            self.emit(SIGNAL("contactCountChanged"),  len(self.contactList))
        
        # Check if the content should be in a new file...
        date = message.dateTime().date()
        if not self.lastPeriod \
            or self.period == Period.Yearly and self.lastPeriod.year() != date.year() \
            or self.period == Period.Monthly and (self.lastPeriod.year() != date.year() or self.lastPeriod.month() != date.month()) \
            or self.period == Period.Daily and (self.lastPeriod.year() != date.year() or self.lastPeriod.month() != date.month()
                                       or self.lastPeriod.day() != date.day()):
    
            if self.files:
                self.finalizeMessageFile(self.files[-1])
            
            self.lastPeriod = date
            
            if self.period == Period.All:
                new = "Messages"
            elif self.period == Period.Yearly:
               new =  "Messages_" + date.toString("yyyy")
            elif self.period == Period.Monthly:
                new =  "Messages_" + date.toString("yyyy_MM")
            else:
                new =  "Messages_" + date.toString("yyyy_MM_dd")
            
            self.emit(SIGNAL("fileChanged"),  new)
            self.messageFiles += 1
            self.emit(SIGNAL("calendarFileCountChanged"),  self.messageFiles)
            if not self.openMessageFile(new):
                return False
            self.files.append(str(new))
        
        return self.subFormatMessage(message)
    
    def formatContactName(self,  contact):
        name = contact.name()
        # Only allow ascii chars in filename and filter special symbols
        name = name.encode('ascii', 'replace')
        
        replace = " !\"#$%&'()*+,-./:;<=>?@[\\]^`{|}~"
        for char in replace:
            name = name.replace(char,  '_')
        
        return str(contact.id()) + "_" + name
    
    def formatContactFile(self,  contact):
        return "Contact_" + self.formatContactName(contact)
    
    def formatContact(self,  contact):
        self.emit(SIGNAL("fileChanged"),  self.formatContactFile(contact))
        if not self.openContactFile(self.formatContactFile(contact)):
            return False
        
        self.subFormatContact(contact)
        self.finalizeContactFile(contact)
    
    def periodString(self):
        if self.period == Period.All:
            return unicode(self.tr("All messages"))
        
        if self.period == Period.Yearly:
           return unicode(self.tr("Messages for %1").arg(self.lastPeriod.toString("yyyy")))
        
        if self.period == Period.Monthly:
            return unicode(self.tr("Messages for %1").arg(self.lastPeriod.toString("MMMM, yyyy")))
        
        return unicode(self.tr("Messages for %1").arg(self.lastPeriod.toString("dddd, dd. MMMM yyyy")))

    # Function needed to be implement in the children
    def initialize(self):
        pass
    def openMessageFile(self,  filename):
        pass
    def subFormatMessage(self,  message):
        raise NotImplementedError, "must be implemented in subclass"
    def finalizeMessageFiles(self):
        raise NotImplementedError, "must be implemented in subclass"
    def writeCalender(self,  filename):
        pass
    def openContactFile(self,  filename):
        pass
    def subFormatContact(self,  contact):
        raise NotImplementedError, "must be implemented in subclass"
    def finalizeContactFile(self,  file):
        raise NotImplementedError, "must be implemented in subclass"
    def finalizeContactFiles(self):
        pass
    def finalizeFiles(self):
        pass

