#include "sspgame.h"

namespace entities
{
	vector<extentity *> ents;

	vector<extentity *> &getents() { return ents; }
	extentity *newentity() { return new sspentity(); }
	void deleteentity(extentity *e) { delete (sspentity *)e; }

	vector<sspitem *> items;

	const char *entmodel(const entity &e)
	{
		switch(e.type)
		{
			case TELEPORT:
				return mapmodelname(e.attr3);
				break;
			default: return NULL;
		}
	}

	int testdist(extentity &e)
	{
		switch(e.type)
		{
			case TELEPORT:
			case CHECKPOINT:
				return e.attr2 != 0 ? abs(e.attr2) : 16;
			case JUMPPAD:
				return e.attr4 != 0 ? abs(e.attr4) : 12;
			case AXIS:
				return e.attr4 != 0 ? abs(e.attr4) : 16;
			default:
				return 24;
		}
	}

	int pickupdist()
	{
		if(game::pickups.inrange(game::player1->armourvec) && game::player1->armour==ARM_ATTRACT)
			return 48;
		else
			return 12; //quadruple distance for attractive armour
	}

	void fixentity(extentity &e)
	{
		switch(e.type)
		{
			case BOX:
			case ENEMY:
			case TELEDEST:
			case CHECKPOINT:
			case PLATFORM:
			{
				e.attr5 = e.attr4;
				e.attr4 = e.attr3;
				e.attr3 = e.attr2;
				e.attr2 = e.attr1;
				e.attr1 = game::player1->yaw;
				break;
			}
		}
	}

	bool teleport(sspent *d, int dest)
	{
		loopv(ents)
		{
			extentity &e = *ents[i];
			if(e.type==TELEDEST && e.attr2 == dest)
			{
				d->o = d->newpos = vec(e.o).add(vec(0, 0, d->eyeheight));
				d->vel = d->falling = vec(0,0,0);
				d->yaw = abs(e.attr1) % 360;
				particle_splash(PART_EDIT, 1250, 750, e.o, d==game::player1 ? 0x0000FF : 0xFF0000, 1.0f, 150, 0x7FFFFF);
				playsound(S_TELEPORT, &e.o);
				return true;

			}
		}
		conoutf("no such teledest: %i", dest);
		return false;
	}

	bool pickuppowerup(sspchar *d, sspitem &i)
	{
		if(d != game::player1 || !game::pickups.inrange(i.index)) return false;  //we currently only want the player to be able to pickup these powerups

		vec emit = i.o;
		emit.z += 5;

		string ds;
		bool pickedup = false;
		///WARNING only use the valid mutations, or there WILL be SERIOUS consequences!
		pickup *p = game::pickups[i.index];

		pickup_generic *gp = (pickup_generic *) p;
		pickup_armour *ap = (pickup_armour *) p;
		//pickup_weapon *wp = (pickup_weapon *) p; ///UNUSED

		switch(p->type)
		{
			case PICKUP_COIN:
				pickedup = true;
				game::player1->coins += gp->amount;

				while(game::player1->coins >= 100 && game::player1->lives < 99)
				{
					game::player1->coins -= 100;
					game::player1->lives += 1;
				}

				formatstring(ds)("%i coin%s", gp->amount, gp->amount==1 ? "" : "s");
				particle_textcopy(emit, ds, PART_TEXT, 2000, 0xffd700, 8.0f, -8);
				break;

			case PICKUP_HEALTH:
				if(gp->amount > 0 && game::player1->maxhealth <= game::player1->health) break; //keeps useful pickups from dissapearing, if you've no need of them yet

				pickedup = true;
				game::player1->health = min(game::player1->maxhealth, game::player1->health + gp->amount); //fully heals players or hurts
				if(gp->amount<0) game::player1->lastpain = lastmillis; //my tummy hurts :(

				formatstring(ds)("%i HP", gp->amount);
				particle_textcopy(emit, ds, PART_TEXT, 2000, gp->amount >= 0 ? 0x00FF00 : 0xFF0000, 8.0f, -8);
				break;

			case PICKUP_TIME:
				pickedup = true;
				game::secsallowed += gp->amount;
				formatstring(ds)("%i second%s", gp->amount, gp->amount==1 ? "" : "s");
				particle_textcopy(emit, ds, PART_TEXT, 2000, gp->amount >= 0 ? 0xAFAFAF : 0xFF0000, 8.0f, -8);
				break;;

			case PICKUP_LIVES:
				if(gp->amount <= 0 || game::player1->lives != 99)
				{
					pickedup = true;
					game::player1->lives = min(99, game::player1->lives + gp->amount);
					formatstring(ds)("%i %s", gp->amount, gp->amount>1 ? "lives" : "life");
					particle_textcopy(emit, ds, PART_TEXT, 2000, 0xffd700, 8.0f, -8);
				}
				break;

			case PICKUP_WEAPON:
				pickedup = true;
				game::player1->gunselect = i.index; //set the player equipped weapon to the valid part of the vector for fire sound and projectile information
				break;

			case PICKUP_ARMOUR:
			{
				pickedup = true;
				game::player1->armourvec = i.index; //just for the appearance
				game::player1->armour = ap->armour;
				const char *type[ARM_MAX] = {"", "Plain", "Attractive", "Winged", "Spiked"};
				formatstring(ds)("%s Armour", type[ap->armour]);
				particle_textcopy(emit, ds, PART_TEXT, 2000, 0x007FFF, 8.0f, -8);
			}
				break;

			default:
				break;
		}
		if (pickedup) particle_splash(PART_STEAM, 200, 200, emit, 0xCFCFCF, 1, 150, -10);
		return pickedup;
	}

	void trypickup(int n, sspchar *d)
	{
		switch(ents[n]->type)
		{
			case TELEPORT:
				if(lastmillis < d->lastpickupmillis + 200) return;
				if(teleport(d, ents[n]->attr1))
					playsound(S_TELEPORT, &ents[n]->o);
				d->lastpickupmillis  = lastmillis;
				return;
			case JUMPPAD:
				if(lastmillis < d->lastpickupmillis + 200) return;
				d->falling = vec(0, 0, 0);
				d->vel.z = ents[n]->attr1 * 10;
				d->vel.y += ents[n]->attr2 * 10;
				d->vel.x += ents[n]->attr3 * 10;
				playsound(S_JUMPPAD, &ents[n]->o);
				d->lastpickupmillis = lastmillis;
				return;
			case CHECKPOINT:
			{
				string ds;
				vec emit = ents[n]->o;
				emit.z += 5;
				switch(ents[n]->attr4)
				{
					case CP_END:
						game::intermission = true;
						formatstring(ds)("Level Completed!");
						break;
					case CP_SAVE:
					default:
						if(n == d->checkpoint)
							return;
						formatstring(ds)("Checkpoint!");
						d->checkpoint = n;
						break;
				}
				particle_textcopy(emit, ds, PART_TEXT, 2000, 0x7FFF7F, 8.0f, -8);
				game::player1->lastpickupmillis  = lastmillis;
				return;
			}
		}
	}

	void checkitems(sspchar *d)
	{
		if(d != game::player1 || editmode) return;
		vec o = d->o;
		o.z -= d->eyeheight;
		loopv(ents)
		{
			extentity &e = *ents[i];
			if(e.type==NOTUSED) continue;
			if(!e.spawned && e.type!=TELEPORT && e.type!=JUMPPAD && e.type!=CHECKPOINT) continue;
			float dist = e.o.dist(o);
			if(dist<testdist(e)) trypickup(i, d);
		}
	}

	void renderent(extentity &e, const char *mdlname, float z, float yaw, int anim = ANIM_MAPMODEL)
	{
		if(!mdlname) return;
		rendermodel(&e.light, mdlname, anim|ANIM_LOOP, vec(e.o).add(vec(0, 0, z)), yaw, 0, MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED);
	}

	void renderentities()
	{
		loopv(ents)
		{
			extentity &e = *ents[i];
			switch(e.type)
			{
				case TELEPORT:
					renderent(e, mapmodelname(e.attr3), (float)(1+sin(lastmillis/100.0+e.o.x+e.o.y)/20), lastmillis/10.0f);
					continue;
				case CHECKPOINT:
					renderent(e, mapmodelname(e.attr3), 0, e.attr1, ANIM_IDLE);
					continue;
				case AXIS:
				{
					int radius = e.attr4 ? abs(e.attr4) : 16;
					vec dir = vec(0, 0, 0);
					vecfromyawpitch(e.attr1, 0, 1, 0, dir);
					dir.mul(radius);
					dir.add(e.o);
					particle_flare(e.o, dir, 1, PART_STREAK, 0x007FFF, 0.4);

					vecfromyawpitch(e.attr2, 0, 1, 0, dir);
					dir.mul(radius);
					dir.add(e.o);
					particle_flare(e.o, dir, 1, PART_STREAK, 0x007FFF, 0.4);
					continue;
				}
				case PICKUP:
					if(editmode && game::pickups.inrange(e.attr1))
					{
						pickup *p = game::pickups[e.attr1];

						rendermodel(
							&e.light,
							p->mdl,
							ANIM_MAPMODEL|ANIM_LOOP,
							vec(e.o).add(vec(0, 0, (float)(1 + sin(lastmillis/300.0)))),
							lastmillis / 10.0f,
							0,
							MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED,
							NULL,
							NULL,
							0,
							0,
							0.5
						); //render a transparent model as a preview
					}
					continue;
				case BOX:
					if(editmode)
					{
						rendermodel(
							&e.light,
							mapmodelname(e.attr2),
							ANIM_MAPMODEL|ANIM_LOOP,
							e.o,
							0,
							0,
							MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED,
							NULL,
							NULL,
							0,
							0,
							0.5
						); //render a transparent model as a preview
					}
					continue;
				default:
					continue;
			}
		}
	}

	void entradius(extentity &e, bool &color)
	{
		switch(e.type)
		{
			case AXIS:
			{
				vec dir;

				vecfromyawpitch(e.attr1, 0, 1, 0, dir);
				renderentarrow(e, dir, testdist(e));

				vecfromyawpitch(e.attr2, 0, 1, 0, dir);
				renderentarrow(e, dir, testdist(e));

				break;
			}
			case CHECKPOINT:
				renderentsphere(e, testdist(e));
				break;
			case ENEMY:
			case TELEDEST:
			case PLATFORMROUTE:
			{
				vec dir;
				vecfromyawpitch(e.attr1, 0, 1, 0, dir);
				renderentarrow(e, dir, 4);
				break;
			}
			case CAMERA:
			{
				vec dir;
				vecfromyawpitch(e.attr2, e.attr3, 1, 0, dir);
				renderentarrow(e, dir, 4);
				break;
			}
			case WAYPOINT:
				loopv(ents)
				{
					if(ents[i]->type == WAYPOINT && e.attr2==ents[i]->attr2)
					{
						renderentarrow(e, vec(ents[i]->o).sub(e.o).normalize(), e.o.dist(ents[i]->o));
						break;
					}
				}
				break;
			case TELEPORT:
				loopv(ents)
				{
					if(ents[i]->type == TELEDEST && e.attr1==ents[i]->attr2)
					{
						renderentarrow(e, vec(ents[i]->o).sub(e.o).normalize(), e.o.dist(ents[i]->o));
						renderentsphere(e, testdist(e) );
						break;
					}
				}
                		break;
			case JUMPPAD:
				renderentarrow(e, vec((int)(char)e.attr3*10.0f, (int)(char)e.attr2*10.0f, e.attr1*12.5f).normalize(), testdist(e));
				renderentsphere(e, testdist(e));
				break;
		}
	}

	bool radiusent(extentity &e)
	{
		switch(e.type)
		{
			case LIGHT:
			case ENVMAP:
			case MAPSOUND:
			case JUMPPAD:
			case TELEPORT:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	bool dirent(extentity &e)
	{
		switch(e.type)
		{
			case AXIS:
			case MAPMODEL:
			case PLAYERSTART:
			case SPOTLIGHT:
			case ENEMY:
			case WAYPOINT:
			case TELEPORT:
			case TELEDEST:
			case CHECKPOINT:
			case JUMPPAD:
			case PLATFORMROUTE:
			case CAMERA:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	void prepareents()
	{
		items.deletecontentsp();
		loopv(ents)
		{
			extentity &e = *ents[i];
			switch(e.type)
			{
				case PICKUP:
				{
					sspitem *item = new sspitem();
					item->init(e.o, e.attr1, true, 0);
					items.add(item);
					continue;
				}
				case BOX:
				{
					if(!game::boxdefs.inrange(e.attr3))
						continue;

					sspbox *box = new sspbox();
					box->init(*game::boxdefs[e.attr3], e);

					game::sspobjs.add(box);
					continue;
				}
				case PLATFORM:
					continue; //TODO, platform spawning
			}
		}
	}

	bool printent(extentity &e, char *buf)
	{
		return false;
	}

	const char *entnameinfo(entity &e) { return ""; }
	int extraentinfosize() {return 0;}

	const char *entname(int i)
	{
		static const char *entnames[] =
		{
			"none?", "light", "mapmodel", "playerstart", "envmap", "particles", "sound", "spotlight", "box", "pickup",
			"enemy", "waypoint", "teleport", "teledest", "checkpoint", "jumppad", "platform", "platformroute", "camera", "axis", "", "", ""
		};
	return i>=0 && size_t(i)<sizeof(entnames)/sizeof(entnames[0]) ? entnames[i] : "";
	}

	void renderhelpertext(extentity &e, int &colour, vec &pos, string &tmp)
	{
		switch(e.type)
		{
			case BOX:
			{
				pos.z += 6.0f;
				formatstring(tmp)("Yaw: %i\nModel: %s (%i)\nINV IDX: %i\nFlags:",
					e.attr1,
					mapmodelname(e.attr2), e.attr2,
					e.attr3
				);
				if(!(e.attr4 & BOX_ALL))
					concatstring(tmp, " persist");
				else
				{
					if(e.attr4 & BOX_DESTROY)
						concatstring(tmp, " destroy");
					if(e.attr4 & BOX_PINJATA)
						concatstring(tmp, " pinjata");
					if(e.attr4 & BOX_EXPLODE)
						concatstring(tmp, " explode");
				}
				return;
			}
			case PICKUP:
				if(game::pickups.inrange(e.attr1))
				{
					static const char *types[] = {"Coins", "Health", "Time", "Lives"};
					switch(game::pickups[e.attr1]->type)
					{
						case PICKUP_COIN:
						case PICKUP_HEALTH:
						case PICKUP_LIVES:
						case PICKUP_TIME:
						{
							pickup_generic *p = (pickup_generic *) game::pickups[e.attr1];
							pos.z += 4.5;
							formatstring(tmp)("Index: %i\nType: %s\nStrength: %i", e.attr1, types[p->type], p->amount);
							break;
						}
						case PICKUP_WEAPON:
							pos.z += 3.0;
							formatstring(tmp)("Index: %i\nType: Weapon", e.attr1);
							break;
						case PICKUP_ARMOUR:
						{
							pickup_armour *ap = (pickup_armour *) game::pickups[e.attr1];
							static const char *armour[] = {"", "Plain", "Attractive", "Winged", "Spike"};
							pos.z += 3.0;
							formatstring(tmp)("Index: %i\nType: %s Armour", e.attr1, armour[ap->armour]);

						}
					}
				}
				else
				{
					pos.z += 1.5;
					formatstring(tmp)("\fs\f3Invalid index %i\fr", e.attr1);
				}
				return;
			case ENEMY:
				pos.z += 3.0;
				formatstring(tmp)("Yaw: %i\nIndex: %i",
					e.attr1,
					e.attr2
				);
				return;
			case WAYPOINT:

				return;
			case TELEPORT:
				pos.z += 4.5;
				formatstring(tmp)("Teleport Tag: %i\nRadius: %i\nModel: %s (%i)",
					e.attr1,
					e.attr2,
					mapmodelname(e.attr3), e.attr3
				);
				return;
			case TELEDEST:
				pos.z += 3.0;
				formatstring(tmp)("Yaw: %i\nTeleport Tag: %i",
					e.attr1,
					e.attr2
				);
				return;
			case CHECKPOINT:
			{
				pos.z += 6.0;
				formatstring(tmp)("Yaw: %i\nRadius: %i\nModel: %s (%i)\nType: %s (%i)",
					e.attr1,
					e.attr2,
					mapmodelname(e.attr3), e.attr3,
					e.attr4 ? "End" : "save", e.attr4
				);
				return;
			}
			case JUMPPAD:
				pos.z += 6.0;
				formatstring(tmp)("Z: %i\nY: %i\nX: %i\nRadius: %i",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4
				);
				return;
			case PLATFORM:

				return;
			case PLATFORMROUTE:

				return;
			case CAMERA:
				pos.z += 6.0;
				formatstring(tmp)("Tag: %i\nYaw: %i\nPitch: %i\nDistance: %i\nType: %s (%i)",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4,
					e.attr5 == 1 ? "Fixed" : "Follow", e.attr5
				);
				return;
			case AXIS:
				pos.z += 7.5;
				formatstring(tmp)("Yaw1: %i\nYaw2:\nTag: axis_script_%i\nRadius: %i\nVert Radius: %i",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4,
					e.attr5
				);
				return;
		}
	}

	void writeent(entity &e, char *buf) {}  // write any additional data to disk (except for ET_ ents)

	void readent(entity &e, char *buf)     // read from disk, and init
	{
		//int ver = getmapversion(); //commented only because it'd unused
	}

	float dropheight(entity &e)
	{
		if (e.type==MAPMODEL) return 0.0f;
		return 4.0f;
	}

	void clearents()
	{
		while(ents.length()) deleteentity(ents.pop());
	}

	//stubs
	void editent(int i) {}
	void rumble(const extentity &e) {}
	void trigger(extentity &e){}
	bool mayattach(extentity &e) { return false; }
	bool attachent(extentity &e, extentity &a) { return false; }

	int *getmodelattr(extentity &e)
	{
		switch(e.type)
		{
			case CHECKPOINT:
			case TELEPORT:
				return &e.attr3;
			case BOX:
				return &e.attr2;
			default:
				return NULL;
		}
	}

	bool checkmodelusage(extentity &e, int i)
	{
		switch(e.type)
		{
			case TELEPORT:
			case CHECKPOINT:
				return e.attr3 == i;
			case BOX:
				return e.attr2 == i;
			default:
				return false;
		}
	}
}

