/*
 * Decompiled with CFR 0.152.
 */
package king;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import king.KingMain;
import king.UIText;
import king.core.KView;
import king.core.Kinemage;
import king.core.MasterGroup;
import king.io.KinfileTokenizer;

public class MageHypertext
implements UIText.HypertextListener {
    KingMain kMain;

    public MageHypertext(KingMain kingMain) {
        this.kMain = kingMain;
    }

    public void mageHypertextHit(String string) {
        try {
            KinfileTokenizer kinfileTokenizer = new KinfileTokenizer(new LineNumberReader(new StringReader(string)));
            while (!kinfileTokenizer.isEOF()) {
                String string2 = kinfileTokenizer.getString().toLowerCase();
                kinfileTokenizer.advance();
                if (string2.equals("kinemage") || string2.equals("kin")) {
                    this.doKinToken(kinfileTokenizer);
                    continue;
                }
                if (string2.equals("view") || string2.equals("v=")) {
                    this.doViewToken(kinfileTokenizer);
                    continue;
                }
                if (string2.startsWith("master") || string2.equals("m=")) {
                    this.doMasterToken(kinfileTokenizer);
                    continue;
                }
                if (!string2.equals("alloff")) continue;
                this.doAllOffToken();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doKinToken(KinfileTokenizer kinfileTokenizer) throws IOException {
        if (kinfileTokenizer.isInteger()) {
            this.kMain.getStable().changeCurrentKinemage(kinfileTokenizer.getInt());
            kinfileTokenizer.advance();
        }
    }

    public void doViewToken(KinfileTokenizer kinfileTokenizer) throws IOException {
        if (kinfileTokenizer.isInteger()) {
            try {
                Kinemage kinemage = this.kMain.getStable().getKinemage();
                KView kView = kinemage.getViewList().get(kinfileTokenizer.getInt() - 1);
                this.kMain.setView(kView);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            kinfileTokenizer.advance();
        }
    }

    public void doMasterToken(KinfileTokenizer kinfileTokenizer) throws IOException {
        if (kinfileTokenizer.isIdentifier()) {
            String string = kinfileTokenizer.getString();
            kinfileTokenizer.advance();
            if (kinfileTokenizer.isLiteral()) {
                String string2 = kinfileTokenizer.getString().toLowerCase();
                kinfileTokenizer.advance();
                Kinemage kinemage = this.kMain.getKinemage();
                if (string2.equals("on")) {
                    kinemage.getMasterByName(string).setOn(true);
                } else if (string2.equals("off")) {
                    kinemage.getMasterByName(string).setOn(false);
                }
            }
        }
    }

    public void doAllOffToken() {
        Kinemage kinemage = this.kMain.getKinemage();
        for (MasterGroup masterGroup : kinemage.masterList()) {
            masterGroup.setOn(false);
        }
    }
}

