/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2.selection;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Selection;
import driftwood.r3.Triple;
import java.text.DecimalFormat;

public class WithinPointTerm
extends Selection {
    private static final DecimalFormat df = new DecimalFormat("0.####");
    double distance;
    double sqDistance;
    Triple center;

    public WithinPointTerm(double d, double d2, double d3, double d4) {
        this.distance = d;
        this.sqDistance = d * d;
        this.center = new Triple(d2, d3, d4);
    }

    protected boolean selectImpl(AtomState atomState) {
        return this.center.sqDistance(atomState) <= this.sqDistance;
    }

    public String toString() {
        return "within " + df.format(this.distance) + " of " + df.format(this.center.getX()) + ", " + df.format(this.center.getY()) + ", " + df.format(this.center.getZ());
    }
}

